/*
 * Decompiled with CFR 0.152.
 */
package io.honnix.rkt.launcher.command;

import io.honnix.rkt.launcher.command.CommandWithoutArgs;
import io.honnix.rkt.launcher.command.Daemonizable;
import io.honnix.rkt.launcher.command.RunBuilder;
import io.honnix.rkt.launcher.options.RunOptions;
import io.honnix.rkt.launcher.output.RunOutput;
import io.honnix.rkt.launcher.output.RunOutputBuilder;
import io.norberg.automatter.AutoMatter;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@AutoMatter
public interface Run
extends Daemonizable,
CommandWithoutArgs<RunOptions, RunOutput> {
    @Override
    public Optional<RunOptions> options();

    @Override
    default public List<String> asList() {
        return this.asList("run");
    }

    @Override
    default public RunOutput parse(String output) {
        RunOutputBuilder runOutputBuilder = RunOutput.builder();
        if (this.daemonize()) {
            Pattern runningPattern = Pattern.compile("Running as unit (.+)\\.");
            Matcher runningMatcher = runningPattern.matcher(output);
            while (runningMatcher.find()) {
                runOutputBuilder.service(runningMatcher.group(1));
            }
        } else {
            runOutputBuilder.service("NA");
        }
        return runOutputBuilder.build();
    }

    public static RunBuilder builder() {
        return new RunBuilder();
    }
}

