/*
 * Decompiled with CFR 0.152.
 */
package io.honnix.rkt.launcher.command;

import io.honnix.rkt.launcher.command.Run;
import io.honnix.rkt.launcher.options.RunOptions;
import io.norberg.automatter.AutoMatter;
import java.util.Optional;

public final class RunBuilder {
    private boolean daemonize;
    private Optional<RunOptions> options;

    public RunBuilder() {
        this.options = Optional.empty();
    }

    private RunBuilder(Run v) {
        this.daemonize = v.daemonize();
        this.options = v.options();
    }

    private RunBuilder(RunBuilder v) {
        this.daemonize = v.daemonize;
        this.options = v.options;
    }

    public boolean daemonize() {
        return this.daemonize;
    }

    public RunBuilder daemonize(boolean daemonize) {
        this.daemonize = daemonize;
        return this;
    }

    public Optional<RunOptions> options() {
        return this.options;
    }

    public RunBuilder options(RunOptions options) {
        return this.options(Optional.ofNullable(options));
    }

    public RunBuilder options(Optional<? extends RunOptions> options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        this.options = options;
        return this;
    }

    public Run build() {
        return new Value(this.daemonize, this.options);
    }

    public static RunBuilder from(Run v) {
        return new RunBuilder(v);
    }

    public static RunBuilder from(RunBuilder v) {
        return new RunBuilder(v);
    }

    private static final class Value
    implements Run {
        private final boolean daemonize;
        private final Optional<RunOptions> options;

        private Value(@AutoMatter.Field(value="daemonize") boolean daemonize, @AutoMatter.Field(value="options") Optional<RunOptions> options) {
            if (options == null) {
                throw new NullPointerException("options");
            }
            this.daemonize = daemonize;
            this.options = options;
        }

        @Override
        @AutoMatter.Field
        public boolean daemonize() {
            return this.daemonize;
        }

        @Override
        @AutoMatter.Field
        public Optional<RunOptions> options() {
            return this.options;
        }

        @Override
        public RunBuilder builder() {
            return new RunBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Run)) {
                return false;
            }
            Run that = (Run)o;
            if (this.daemonize != that.daemonize()) {
                return false;
            }
            return !(this.options != null ? !this.options.equals(that.options()) : that.options() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.daemonize ? 1231 : 1237);
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Run{daemonize=" + this.daemonize + ", options=" + this.options + '}';
        }
    }
}

