/*
 * Decompiled with CFR 0.152.
 */
package io.honnix.rkt.launcher.command;

import io.honnix.rkt.launcher.command.RunPrepared;
import io.honnix.rkt.launcher.options.RunPreparedOptions;
import io.norberg.automatter.AutoMatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public final class RunPreparedBuilder {
    private boolean daemonize;
    private Optional<RunPreparedOptions> options;
    private List<String> args;

    public RunPreparedBuilder() {
        this.options = Optional.empty();
    }

    private RunPreparedBuilder(RunPrepared v) {
        this.daemonize = v.daemonize();
        this.options = v.options();
        List<String> _args = v.args();
        this.args = _args == null ? null : new ArrayList<String>(_args);
    }

    private RunPreparedBuilder(RunPreparedBuilder v) {
        this.daemonize = v.daemonize;
        this.options = v.options;
        this.args = v.args == null ? null : new ArrayList<String>(v.args);
    }

    public boolean daemonize() {
        return this.daemonize;
    }

    public RunPreparedBuilder daemonize(boolean daemonize) {
        this.daemonize = daemonize;
        return this;
    }

    public Optional<RunPreparedOptions> options() {
        return this.options;
    }

    public RunPreparedBuilder options(RunPreparedOptions options) {
        return this.options(Optional.ofNullable(options));
    }

    public RunPreparedBuilder options(Optional<? extends RunPreparedOptions> options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        this.options = options;
        return this;
    }

    public List<String> args() {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        return this.args;
    }

    public RunPreparedBuilder args(List<? extends String> args) {
        return this.args((Collection<? extends String>)args);
    }

    public RunPreparedBuilder args(Collection<? extends String> args) {
        if (args == null) {
            throw new NullPointerException("args");
        }
        for (String string : args) {
            if (string != null) continue;
            throw new NullPointerException("args: null item");
        }
        this.args = new ArrayList<String>(args);
        return this;
    }

    public RunPreparedBuilder args(Iterable<? extends String> args) {
        if (args == null) {
            throw new NullPointerException("args");
        }
        if (args instanceof Collection) {
            return this.args((Collection)args);
        }
        return this.args(args.iterator());
    }

    public RunPreparedBuilder args(Iterator<? extends String> args) {
        if (args == null) {
            throw new NullPointerException("args");
        }
        this.args = new ArrayList<String>();
        while (args.hasNext()) {
            String item = args.next();
            if (item == null) {
                throw new NullPointerException("args: null item");
            }
            this.args.add(item);
        }
        return this;
    }

    @SafeVarargs
    public final RunPreparedBuilder args(String ... args) {
        if (args == null) {
            throw new NullPointerException("args");
        }
        return this.args(Arrays.asList(args));
    }

    public RunPreparedBuilder addArg(String arg) {
        if (arg == null) {
            throw new NullPointerException("arg");
        }
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.add(arg);
        return this;
    }

    public RunPrepared build() {
        List _args = this.args != null ? Collections.unmodifiableList(new ArrayList<String>(this.args)) : Collections.emptyList();
        return new Value(this.daemonize, this.options, _args);
    }

    public static RunPreparedBuilder from(RunPrepared v) {
        return new RunPreparedBuilder(v);
    }

    public static RunPreparedBuilder from(RunPreparedBuilder v) {
        return new RunPreparedBuilder(v);
    }

    private static final class Value
    implements RunPrepared {
        private final boolean daemonize;
        private final Optional<RunPreparedOptions> options;
        private final List<String> args;

        private Value(@AutoMatter.Field(value="daemonize") boolean daemonize, @AutoMatter.Field(value="options") Optional<RunPreparedOptions> options, @AutoMatter.Field(value="args") List<String> args) {
            if (options == null) {
                throw new NullPointerException("options");
            }
            this.daemonize = daemonize;
            this.options = options;
            this.args = args != null ? args : Collections.emptyList();
        }

        @Override
        @AutoMatter.Field
        public boolean daemonize() {
            return this.daemonize;
        }

        @Override
        @AutoMatter.Field
        public Optional<RunPreparedOptions> options() {
            return this.options;
        }

        @Override
        @AutoMatter.Field
        public List<String> args() {
            return this.args;
        }

        @Override
        public RunPreparedBuilder builder() {
            return new RunPreparedBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RunPrepared)) {
                return false;
            }
            RunPrepared that = (RunPrepared)o;
            if (this.daemonize != that.daemonize()) {
                return false;
            }
            if (this.options != null ? !this.options.equals(that.options()) : that.options() != null) {
                return false;
            }
            return !(this.args != null ? !this.args.equals(that.args()) : that.args() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.daemonize ? 1231 : 1237);
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "RunPrepared{daemonize=" + this.daemonize + ", options=" + this.options + ", args=" + this.args + '}';
        }
    }
}

