/*
 * Decompiled with CFR 0.152.
 */
package io.honnix.rkt.launcher.command;

import io.honnix.rkt.launcher.command.CommandWithArgs;
import io.honnix.rkt.launcher.command.StatusBuilder;
import io.honnix.rkt.launcher.exception.RktUnexpectedOutputException;
import io.honnix.rkt.launcher.model.Pod;
import io.honnix.rkt.launcher.options.StatusOptions;
import io.honnix.rkt.launcher.output.StatusOutput;
import io.honnix.rkt.launcher.util.Json;
import io.norberg.automatter.AutoMatter;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

@AutoMatter
public interface Status
extends CommandWithArgs<StatusOptions, StatusOutput> {
    @Override
    public Optional<StatusOptions> options();

    @Override
    default public List<String> asList() {
        return this.asList("status");
    }

    @Override
    default public StatusOutput parse(String output) {
        String modifiedOutput = output.replaceAll("\"app_names\"", "\"appNames\"").replaceAll("\"started_at\"", "\"startedAt\"").replaceAll("\"user_annotations\"", "\"userAnnotations\"").replaceAll("\"user_labels\"", "\"userLabels\"").replaceAll("\"created_at\"", "\"createdAt\"").replaceAll("\"image_id\"", "\"imageId\"");
        try {
            return StatusOutput.builder().status((Pod)Json.deserialize((String)modifiedOutput, Pod.class)).build();
        }
        catch (IOException e) {
            throw new RktUnexpectedOutputException("failed parsing JSON output", e);
        }
    }

    public static StatusBuilder builder() {
        return new StatusBuilder();
    }
}

