/*
 * Decompiled with CFR 0.152.
 */
package io.honnix.rkt.launcher.command;

import io.honnix.rkt.launcher.command.Status;
import io.honnix.rkt.launcher.options.StatusOptions;
import io.norberg.automatter.AutoMatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public final class StatusBuilder {
    private Optional<StatusOptions> options;
    private List<String> args;

    public StatusBuilder() {
        this.options = Optional.empty();
    }

    private StatusBuilder(Status v) {
        this.options = v.options();
        List<String> _args = v.args();
        this.args = _args == null ? null : new ArrayList<String>(_args);
    }

    private StatusBuilder(StatusBuilder v) {
        this.options = v.options;
        this.args = v.args == null ? null : new ArrayList<String>(v.args);
    }

    public Optional<StatusOptions> options() {
        return this.options;
    }

    public StatusBuilder options(StatusOptions options) {
        return this.options(Optional.ofNullable(options));
    }

    public StatusBuilder options(Optional<? extends StatusOptions> options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        this.options = options;
        return this;
    }

    public List<String> args() {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        return this.args;
    }

    public StatusBuilder args(List<? extends String> args) {
        return this.args((Collection<? extends String>)args);
    }

    public StatusBuilder args(Collection<? extends String> args) {
        if (args == null) {
            throw new NullPointerException("args");
        }
        for (String string : args) {
            if (string != null) continue;
            throw new NullPointerException("args: null item");
        }
        this.args = new ArrayList<String>(args);
        return this;
    }

    public StatusBuilder args(Iterable<? extends String> args) {
        if (args == null) {
            throw new NullPointerException("args");
        }
        if (args instanceof Collection) {
            return this.args((Collection)args);
        }
        return this.args(args.iterator());
    }

    public StatusBuilder args(Iterator<? extends String> args) {
        if (args == null) {
            throw new NullPointerException("args");
        }
        this.args = new ArrayList<String>();
        while (args.hasNext()) {
            String item = args.next();
            if (item == null) {
                throw new NullPointerException("args: null item");
            }
            this.args.add(item);
        }
        return this;
    }

    @SafeVarargs
    public final StatusBuilder args(String ... args) {
        if (args == null) {
            throw new NullPointerException("args");
        }
        return this.args(Arrays.asList(args));
    }

    public StatusBuilder addArg(String arg) {
        if (arg == null) {
            throw new NullPointerException("arg");
        }
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.add(arg);
        return this;
    }

    public Status build() {
        List _args = this.args != null ? Collections.unmodifiableList(new ArrayList<String>(this.args)) : Collections.emptyList();
        return new Value(this.options, _args);
    }

    public static StatusBuilder from(Status v) {
        return new StatusBuilder(v);
    }

    public static StatusBuilder from(StatusBuilder v) {
        return new StatusBuilder(v);
    }

    private static final class Value
    implements Status {
        private final Optional<StatusOptions> options;
        private final List<String> args;

        private Value(@AutoMatter.Field(value="options") Optional<StatusOptions> options, @AutoMatter.Field(value="args") List<String> args) {
            if (options == null) {
                throw new NullPointerException("options");
            }
            this.options = options;
            this.args = args != null ? args : Collections.emptyList();
        }

        @Override
        @AutoMatter.Field
        public Optional<StatusOptions> options() {
            return this.options;
        }

        @Override
        @AutoMatter.Field
        public List<String> args() {
            return this.args;
        }

        @Override
        public StatusBuilder builder() {
            return new StatusBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Status)) {
                return false;
            }
            Status that = (Status)o;
            if (this.options != null ? !this.options.equals(that.options()) : that.options() != null) {
                return false;
            }
            return !(this.args != null ? !this.args.equals(that.args()) : that.args() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Status{options=" + this.options + ", args=" + this.args + '}';
        }
    }
}

