/*
 * Decompiled with CFR 0.152.
 */
package io.honnix.rkt.launcher.command;

import com.google.common.collect.Lists;
import io.honnix.rkt.launcher.command.CommandWithOptionalArgs;
import io.honnix.rkt.launcher.command.TrustBuilder;
import io.honnix.rkt.launcher.exception.RktUnexpectedOutputException;
import io.honnix.rkt.launcher.model.TrustedPubkey;
import io.honnix.rkt.launcher.options.TrustOptions;
import io.honnix.rkt.launcher.output.TrustOutput;
import io.honnix.rkt.launcher.output.TrustOutputBuilder;
import io.norberg.automatter.AutoMatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@AutoMatter
public interface Trust
extends CommandWithOptionalArgs<TrustOptions, TrustOutput> {
    @Override
    public Optional<TrustOptions> options();

    @Override
    default public List<String> asList() {
        return this.asList("trust");
    }

    @Override
    default public TrustOutput parse(String output) {
        TrustOutputBuilder trustOutputBuilder = TrustOutput.builder();
        Pattern prefixPattern = Pattern.compile("pubkey: prefix: \"(.*)\"");
        Pattern keyPattern = Pattern.compile("key: \"(.+)\"");
        Pattern locationPattern = Pattern.compile("Added .* at \"(.+)\"");
        ArrayList prefixes = Lists.newArrayList();
        ArrayList keys = Lists.newArrayList();
        ArrayList locations = Lists.newArrayList();
        Matcher prefixMatcher = prefixPattern.matcher(output);
        while (prefixMatcher.find()) {
            prefixes.add(prefixMatcher.group(1));
        }
        Matcher keyMatcher = keyPattern.matcher(output);
        while (keyMatcher.find()) {
            keys.add(keyMatcher.group(1));
        }
        Matcher locationMatcher = locationPattern.matcher(output);
        while (locationMatcher.find()) {
            locations.add(locationMatcher.group(1));
        }
        if (prefixes.size() == keys.size() && prefixes.size() == locations.size()) {
            for (int i = 0; i < prefixes.size(); ++i) {
                TrustedPubkey trustedPubkey = TrustedPubkey.builder().prefix((String)prefixes.get(i)).key((String)keys.get(i)).location((String)locations.get(i)).build();
                trustOutputBuilder.addTrustedPubkey(trustedPubkey);
            }
        } else {
            throw new RktUnexpectedOutputException("missing value(s) in output");
        }
        return trustOutputBuilder.build();
    }

    public static TrustBuilder builder() {
        return new TrustBuilder();
    }
}

