/*
 * Decompiled with CFR 0.152.
 */
package io.honnix.rkt.launcher.command;

import io.honnix.rkt.launcher.command.Trust;
import io.honnix.rkt.launcher.options.TrustOptions;
import io.norberg.automatter.AutoMatter;
import java.util.List;
import java.util.Optional;

public final class TrustBuilder {
    private Optional<TrustOptions> options;
    private Optional<List<String>> args;

    public TrustBuilder() {
        this.options = Optional.empty();
        this.args = Optional.empty();
    }

    private TrustBuilder(Trust v) {
        this.options = v.options();
        this.args = v.args();
    }

    private TrustBuilder(TrustBuilder v) {
        this.options = v.options;
        this.args = v.args;
    }

    public Optional<TrustOptions> options() {
        return this.options;
    }

    public TrustBuilder options(TrustOptions options) {
        return this.options(Optional.ofNullable(options));
    }

    public TrustBuilder options(Optional<? extends TrustOptions> options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        this.options = options;
        return this;
    }

    public Optional<List<String>> args() {
        return this.args;
    }

    public TrustBuilder args(List<String> args) {
        return this.args(Optional.ofNullable(args));
    }

    public TrustBuilder args(Optional<? extends List<String>> args) {
        if (args == null) {
            throw new NullPointerException("args");
        }
        this.args = args;
        return this;
    }

    public Trust build() {
        return new Value(this.options, this.args);
    }

    public static TrustBuilder from(Trust v) {
        return new TrustBuilder(v);
    }

    public static TrustBuilder from(TrustBuilder v) {
        return new TrustBuilder(v);
    }

    private static final class Value
    implements Trust {
        private final Optional<TrustOptions> options;
        private final Optional<List<String>> args;

        private Value(@AutoMatter.Field(value="options") Optional<TrustOptions> options, @AutoMatter.Field(value="args") Optional<List<String>> args) {
            if (options == null) {
                throw new NullPointerException("options");
            }
            if (args == null) {
                throw new NullPointerException("args");
            }
            this.options = options;
            this.args = args;
        }

        @Override
        @AutoMatter.Field
        public Optional<TrustOptions> options() {
            return this.options;
        }

        @Override
        @AutoMatter.Field
        public Optional<List<String>> args() {
            return this.args;
        }

        @Override
        public TrustBuilder builder() {
            return new TrustBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Trust)) {
                return false;
            }
            Trust that = (Trust)o;
            if (this.options != null ? !this.options.equals(that.options()) : that.options() != null) {
                return false;
            }
            return !(this.args != null ? !this.args.equals(that.args()) : that.args() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Trust{options=" + this.options + ", args=" + this.args + '}';
        }
    }
}

