/*
 * Decompiled with CFR 0.152.
 */
package io.honnix.rkt.launcher.command;

import com.google.common.collect.ImmutableList;
import io.honnix.rkt.launcher.command.CommandWithoutArgs;
import io.honnix.rkt.launcher.command.VersionBuilder;
import io.honnix.rkt.launcher.exception.RktUnexpectedOutputException;
import io.honnix.rkt.launcher.options.Options;
import io.honnix.rkt.launcher.output.VersionOutput;
import io.honnix.rkt.launcher.output.VersionOutputBuilder;
import io.norberg.automatter.AutoMatter;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@AutoMatter
public interface Version
extends CommandWithoutArgs<Options, VersionOutput> {
    public static final Version COMMAND = Version.builder().build();

    @Override
    default public Optional<Options> options() {
        return Optional.of(Options.NULL);
    }

    @Override
    default public List<String> asList() {
        return this.asList("version");
    }

    @Override
    default public VersionOutput parse(String output) {
        VersionOutputBuilder versionOutputBuilder = VersionOutput.builder();
        Pattern rktVersionPattern = Pattern.compile("rkt Version: (.+)");
        Pattern appcVersionPattern = Pattern.compile("appc Version: (.+)");
        Pattern goVersionPattern = Pattern.compile("Go Version: (.+)");
        Pattern goOSArchPattern = Pattern.compile("Go OS/Arch: (.+)");
        Pattern featuresPattern = Pattern.compile("Features: (.+)");
        Matcher rktVersionMatch = rktVersionPattern.matcher(output);
        if (!rktVersionMatch.find()) {
            throw new RktUnexpectedOutputException("no rkt version found");
        }
        versionOutputBuilder.rktVersion(rktVersionMatch.group(1));
        Matcher appcVersionMatch = appcVersionPattern.matcher(output);
        if (!appcVersionMatch.find()) {
            throw new RktUnexpectedOutputException("no appc version found");
        }
        versionOutputBuilder.appcVersion(appcVersionMatch.group(1));
        Matcher goVersionMatch = goVersionPattern.matcher(output);
        if (!goVersionMatch.find()) {
            throw new RktUnexpectedOutputException("no Go version found");
        }
        versionOutputBuilder.goVersion(goVersionMatch.group(1));
        Matcher goOSArchMatcher = goOSArchPattern.matcher(output);
        if (!goOSArchMatcher.find()) {
            throw new RktUnexpectedOutputException("no Go OS/Arch found");
        }
        versionOutputBuilder.goOSArch(goOSArchMatcher.group(1));
        Matcher featuresMatcher = featuresPattern.matcher(output);
        if (!featuresMatcher.find()) {
            throw new RktUnexpectedOutputException("no features found");
        }
        versionOutputBuilder.features((List)ImmutableList.copyOf((Object[])featuresMatcher.group(1).split(" ")));
        return versionOutputBuilder.build();
    }

    public static VersionBuilder builder() {
        return new VersionBuilder();
    }
}

