/*
 * Decompiled with CFR 0.152.
 */
package io.honnix.rkt.launcher.command.image;

import io.honnix.rkt.launcher.command.CommandWithoutArgs;
import io.honnix.rkt.launcher.command.image.GcBuilder;
import io.honnix.rkt.launcher.command.image.Image;
import io.honnix.rkt.launcher.options.image.GcOptions;
import io.honnix.rkt.launcher.output.image.GcOutput;
import io.honnix.rkt.launcher.output.image.GcOutputBuilder;
import io.norberg.automatter.AutoMatter;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@AutoMatter
public interface Gc
extends CommandWithoutArgs<GcOptions, GcOutput> {
    @Override
    public Optional<GcOptions> options();

    @Override
    default public List<String> asList() {
        return Image.image(this.asList("gc"));
    }

    @Override
    default public GcOutput parse(String output) {
        GcOutputBuilder gcOutputBuilder = GcOutput.builder();
        Pattern removedTreestorePattern = Pattern.compile("removed treestore \"(.+)\"");
        Pattern removedImagePattern = Pattern.compile("successfully removed aci for image: \"(.+)\"");
        Matcher removedTreestoreMatcher = removedTreestorePattern.matcher(output);
        while (removedTreestoreMatcher.find()) {
            gcOutputBuilder.removedTreestores().add(removedTreestoreMatcher.group(1));
        }
        Matcher removedImageMatcher = removedImagePattern.matcher(output);
        while (removedImageMatcher.find()) {
            gcOutputBuilder.removedImages().add(removedImageMatcher.group(1));
        }
        return gcOutputBuilder.build();
    }

    public static GcBuilder builder() {
        return new GcBuilder();
    }
}

