/*
 * Decompiled with CFR 0.152.
 */
package examples;

import io.hoplin.RabbitMQOptions;
import io.hoplin.SubscriptionResult;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseExample {
    private static final Logger log = LoggerFactory.getLogger(BaseExample.class);

    protected static RabbitMQOptions options() {
        RabbitMQOptions options = new RabbitMQOptions();
        options.setConnectionRetries(Integer.valueOf(25));
        options.setConnectionRetryDelay(500L);
        return options;
    }

    protected static RabbitMQOptions options(String connectionString) {
        return RabbitMQOptions.from((String)connectionString);
    }

    protected static void info(SubscriptionResult subscription) {
        Objects.requireNonNull(subscription);
        log.info("Subscription Exchange         : {}", (Object)subscription.getExchange());
        log.info("Subscription Queue            : {}", (Object)subscription.getQueue());
        log.info("Subscription ErrorExchange    : {}", (Object)subscription.getErrorExchangeName());
        log.info("Subscription ErrrorQueue      : {}", (Object)subscription.getErrorQueueName());
    }
}

