/*
 * Decompiled with CFR 0.152.
 */
package examples.batch;

import examples.BaseExample;
import examples.LogDetail;
import io.hoplin.Binding;
import io.hoplin.BindingBuilder;
import io.hoplin.DirectExchange;
import io.hoplin.batch.DefaultBatchClient;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchProcessingExample
extends BaseExample {
    private static final Logger log = LoggerFactory.getLogger(BatchProcessingExample.class);

    public static void main(String ... args) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        DefaultBatchClient client = new DefaultBatchClient(BatchProcessingExample.options(), BatchProcessingExample.bind());
        client.startNew(context -> {
            for (int i = 0; i < 2; ++i) {
                context.enqueue(() -> new LogDetail("Msg >> " + System.nanoTime(), "info"));
                context.enqueue(() -> new LogDetail("Msg >> " + System.nanoTime(), "warn"));
            }
        }).whenComplete((context, throwable) -> {
            log.info("Batch completed in : {}", (Object)context.duration());
            latch.countDown();
        });
        latch.await();
    }

    private static Binding bind() {
        return BindingBuilder.bind((String)"batch.documents").to(new DirectExchange("exchange.batch")).build();
    }
}

