/*
 * Decompiled with CFR 0.152.
 */
package examples.batch;

import examples.BaseExample;
import examples.LogDetail;
import io.hoplin.DirectExchangeClient;
import io.hoplin.ExchangeClient;
import io.hoplin.MessageContext;
import io.hoplin.RabbitMQOptions;
import io.hoplin.Reply;
import io.hoplin.SubscriptionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiveBatchJob
extends BaseExample {
    private static final Logger log = LoggerFactory.getLogger(ReceiveBatchJob.class);
    private static final String EXCHANGE = "exchange.batch";

    public static void main(String ... args) throws InterruptedException {
        ExchangeClient client = DirectExchangeClient.create((RabbitMQOptions)ReceiveBatchJob.options(), (String)EXCHANGE);
        SubscriptionResult subscription = client.subscribe("test", LogDetail.class, ReceiveBatchJob::handleWithReply);
        log.info("Subscription : {}", (Object)subscription);
        Thread.currentThread().join();
    }

    private static Reply<LogDetail> handleWithReply(LogDetail msg, MessageContext context) {
        LogDetail reply = new LogDetail("Reply Message > " + System.nanoTime(), "WARN");
        log.info("Processing message : {} , {}", (Object)msg, (Object)context);
        return Reply.with((Object)reply);
    }

    private static LogDetail handleDirectReturn(LogDetail msg) {
        return new LogDetail("ReplyX Message > " + System.nanoTime(), "WARN");
    }
}

