/*
 * Decompiled with CFR 0.152.
 */
package examples.logdirect;

import examples.BaseExample;
import examples.LogDetail;
import examples.logdirect.EmitLogDirect;
import io.hoplin.ExchangeClient;
import io.hoplin.RabbitMQOptions;
import io.hoplin.SubscriptionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiveLogsDirect
extends BaseExample {
    private static final Logger log = LoggerFactory.getLogger(EmitLogDirect.class);
    private static final String EXCHANGE = "direct_logs";

    public static void main(String ... args) throws InterruptedException {
        ExchangeClient client = ReceiveLogsDirect.informative();
        SubscriptionResult subscription = client.subscribe("test", LogDetail.class, msg -> log.info("Message received [{}]", msg));
        ReceiveLogsDirect.info(subscription);
        Thread.currentThread().join();
    }

    private static ExchangeClient critical() {
        return ExchangeClient.direct((RabbitMQOptions)ReceiveLogsDirect.options(), (String)EXCHANGE, (String)"log.critical", (String)"error");
    }

    private static ExchangeClient informative() {
        return ExchangeClient.direct((RabbitMQOptions)ReceiveLogsDirect.options(), (String)EXCHANGE, (String)"log.informative", (String)"info");
    }
}

