/*
 * Decompiled with CFR 0.152.
 */
package examples.logheader;

import examples.BaseExample;
import examples.LogDetail;
import io.hoplin.Binding;
import io.hoplin.BindingBuilder;
import io.hoplin.ExchangeClient;
import io.hoplin.HeaderExchange;
import io.hoplin.RabbitMQOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiveLogHeader
extends BaseExample {
    private static final Logger log = LoggerFactory.getLogger(ReceiveLogHeader.class);
    private static final String EXCHANGE = "header_logs";

    public static void main(String ... args) throws InterruptedException {
        log.info("Starting header consumer for exchange : {}", (Object)EXCHANGE);
        ExchangeClient client = ReceiveLogHeader.clientFromBinding(EXCHANGE, "info", "service-xyz");
        client.subscribe("test", LogDetail.class, ReceiveLogHeader::handler);
        Thread.currentThread().join();
    }

    private static void handler(LogDetail detail) {
        log.info("Message received :  {} ", (Object)detail);
    }

    private static ExchangeClient clientFromBinding(String exchange, String type, String category) {
        Binding binding = BindingBuilder.bind((String)"header_log_info_queue").to(new HeaderExchange(exchange)).withArgument("x-match", (Object)"all").withArgument("type", (Object)type).withArgument("category", (Object)category).build();
        return ExchangeClient.header((RabbitMQOptions)ReceiveLogHeader.options(), (Binding)binding);
    }
}

