/*
 * Decompiled with CFR 0.152.
 */
package examples.logtopic;

import examples.BaseExample;
import examples.LogDetail;
import examples.logdirect.EmitLogDirect;
import io.hoplin.Binding;
import io.hoplin.BindingBuilder;
import io.hoplin.ExchangeClient;
import io.hoplin.RabbitMQOptions;
import io.hoplin.SubscriptionResult;
import io.hoplin.TopicExchange;
import io.hoplin.metrics.FunctionMetricsPublisher;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiveLogsTopic
extends BaseExample {
    private static final Logger log = LoggerFactory.getLogger(EmitLogDirect.class);
    private static final String EXCHANGE = "topic_logs";

    public static void main(String ... args) throws InterruptedException {
        FunctionMetricsPublisher.consumer(ReceiveLogsTopic::metrics).withInterval(1L, TimeUnit.SECONDS).withResetOnReporting(false).build().start();
        ExchangeClient client = ExchangeClient.topic((RabbitMQOptions)ReceiveLogsTopic.options());
        SubscriptionResult sub = client.subscribe("test", LogDetail.class, msg -> log.info("Message received [{}]", msg));
        ReceiveLogsTopic.info(sub);
        Thread.currentThread().join();
    }

    private static void metrics(Object o) {
        System.out.println("Metrics Info : " + o);
    }

    private static ExchangeClient clientFromExchange(String exchange, String queue, String routingKey) {
        return ExchangeClient.topic((RabbitMQOptions)ReceiveLogsTopic.options(), (String)exchange, (String)queue, (String)routingKey);
    }

    private static ExchangeClient clientFromBinding(String exchange, String queue, String routingKey) {
        Binding binding = ((BindingBuilder.TopicExchangeRoutingKeyConfigurer)((BindingBuilder.TopicExchangeRoutingKeyConfigurer)((BindingBuilder.TopicExchangeRoutingKeyConfigurer)((BindingBuilder.TopicExchangeRoutingKeyConfigurer)BindingBuilder.bind((String)queue).to(new TopicExchange(exchange)).withAutoAck(true)).withPrefetchCount(1)).withPublisherConfirms(true)).with(routingKey)).build();
        return ExchangeClient.topic((RabbitMQOptions)ReceiveLogsTopic.options(), (Binding)binding);
    }
}

