/*
 * Decompiled with CFR 0.152.
 */
package examples.metrics;

import examples.BaseExample;
import examples.LogDetail;
import io.hoplin.Binding;
import io.hoplin.BindingBuilder;
import io.hoplin.ExchangeClient;
import io.hoplin.RabbitMQOptions;
import io.hoplin.TopicExchange;
import io.hoplin.metrics.FunctionMetricsPublisher;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmitMetrics
extends BaseExample {
    private static final Logger log = LoggerFactory.getLogger(EmitMetrics.class);
    private static final String EXCHANGE = "examples.metrics";

    public static void main(String ... args) throws InterruptedException {
        FunctionMetricsPublisher.consumer(EmitMetrics::metrics).withInterval(1L, TimeUnit.SECONDS).withResetOnReporting(false).build().start();
        log.info("Starting producer for exchange : {}", (Object)EXCHANGE);
        ExchangeClient client = EmitMetrics.clientFromBinding();
        client.publish((Object)EmitMetrics.createMessage("warning"), "log.critical.warning");
        Thread.currentThread().join();
    }

    private static void metrics(Map<String, Map<String, String>> o) {
        log.info("Metrics Info : {}", o);
    }

    private static ExchangeClient clientFromExchange() {
        return ExchangeClient.topic((RabbitMQOptions)EmitMetrics.options(), (String)EXCHANGE);
    }

    private static ExchangeClient clientFromBinding() {
        Binding binding = ((BindingBuilder.TopicExchangeRoutingKeyConfigurer)((BindingBuilder.TopicExchangeRoutingKeyConfigurer)((BindingBuilder.TopicExchangeRoutingKeyConfigurer)BindingBuilder.bind().to(new TopicExchange(EXCHANGE)).withAutoAck(true)).withPrefetchCount(1)).withPublisherConfirms(true)).build();
        return ExchangeClient.topic((RabbitMQOptions)EmitMetrics.options(), (Binding)binding);
    }

    private static LogDetail createMessage(String level) {
        return new LogDetail("Msg : " + System.nanoTime(), level);
    }
}

