/*
 * Decompiled with CFR 0.152.
 */
package examples.publisherconsumer;

import examples.BaseExample;
import examples.LogDetail;
import io.hoplin.ExchangeClient;
import io.hoplin.RabbitMQOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamePublisherConsumerExample
extends BaseExample {
    private static final Logger log = LoggerFactory.getLogger(SamePublisherConsumerExample.class);
    private static final String EXCHANGE = "topic_logs";

    public static void main(String ... args) throws InterruptedException {
        log.info("Starting producer/consumer for exchange : {}", (Object)EXCHANGE);
        ExchangeClient client = ExchangeClient.topic((RabbitMQOptions)SamePublisherConsumerExample.options(), (String)EXCHANGE);
        client.subscribe("Test", LogDetail.class, SamePublisherConsumerExample::handle);
        for (int i = 0; i < 5; ++i) {
            client.publish((Object)SamePublisherConsumerExample.createMessage("info"), "log.info.info");
            client.publish((Object)SamePublisherConsumerExample.createMessage("debug"), "log.info.debug");
            Thread.sleep(1000L);
        }
    }

    private static void handle(LogDetail msg) {
        log.info("Incoming msg : {}", (Object)msg);
    }

    private static LogDetail createMessage(String level) {
        return new LogDetail("Msg : " + System.nanoTime(), level);
    }
}

