/*
 * Decompiled with CFR 0.152.
 */
package examples.rpc;

import examples.BaseExample;
import examples.LogDetail;
import examples.rpc.LogDetailRequest;
import examples.rpc.LogDetailResponse;
import io.hoplin.Binding;
import io.hoplin.BindingBuilder;
import io.hoplin.DirectExchange;
import io.hoplin.RabbitMQOptions;
import io.hoplin.rpc.DefaultRpcClient;
import io.hoplin.rpc.RpcClient;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcClientExample
extends BaseExample {
    private static final Logger log = LoggerFactory.getLogger(RpcClientExample.class);

    public static void main(String ... args) throws IOException {
        Binding binding = RpcClientExample.bind();
        log.info("Binding : {}", (Object)binding);
        RpcClient client = DefaultRpcClient.create((RabbitMQOptions)RpcClientExample.options(), (Binding)binding);
        for (int i = 0; i < 100; ++i) {
            LogDetailResponse response = (LogDetailResponse)client.request((Object)new LogDetailRequest("Request message 1", "info"));
            log.info("RPC Value = {}", (Object)response);
        }
    }

    public static void mainXX(String ... args) throws IOException {
        Binding binding = RpcClientExample.bind();
        log.info("Binding : {}", (Object)binding);
        RpcClient client = DefaultRpcClient.create((RabbitMQOptions)RpcClientExample.options(), (Binding)binding);
        System.out.println("Waiting");
        LogDetailResponse response1 = (LogDetailResponse)client.request((Object)new LogDetailRequest("Request message 1", "info"));
        log.info("RPC response : {} ", (Object)response1);
    }

    private static void request(RpcClient<LogDetail, String> client) {
        long s = System.currentTimeMillis();
        int tickets = 1;
        for (int i = 0; i < tickets; ++i) {
            String reply = (String)client.request((Object)new LogDetail("Msg : " + System.nanoTime(), "info"));
            System.out.println("Reply : " + reply);
        }
        long e = System.currentTimeMillis() - s;
        System.out.println("time : " + e);
    }

    private static void asyncRequest(RpcClient<LogDetail, String> client) throws InterruptedException {
        long s = System.currentTimeMillis();
        int tickets = 1000;
        CountDownLatch latch = new CountDownLatch(tickets);
        for (int i = 0; i < tickets; ++i) {
            client.requestAsync((Object)new LogDetail("Msg : " + System.nanoTime(), "info")).whenComplete((reply, t) -> {
                latch.countDown();
                System.out.println("Reply : " + reply);
            });
        }
        latch.await();
        long e = System.currentTimeMillis() - s;
        System.out.println("time : " + e);
    }

    private static Binding bind() {
        return ((BindingBuilder.DirectExchangeRoutingKeyConfigurer)BindingBuilder.bind((String)"rpc.request.log").to(new DirectExchange("exchange.rpc.logs")).withPrefetchCount(4)).build();
    }
}

