/*
 * Decompiled with CFR 0.152.
 */
package examples.rpc;

import examples.BaseExample;
import examples.rpc.LogDetailRequest;
import examples.rpc.LogDetailResponse;
import io.hoplin.Binding;
import io.hoplin.BindingBuilder;
import io.hoplin.DirectExchange;
import io.hoplin.RabbitMQOptions;
import io.hoplin.metrics.FunctionMetricsPublisher;
import io.hoplin.rpc.DefaultRpcServer;
import io.hoplin.rpc.RpcServer;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcServerExample
extends BaseExample {
    private static final Logger log = LoggerFactory.getLogger(RpcServerExample.class);

    public static void main(String ... args) throws InterruptedException {
        Binding binding = RpcServerExample.bind();
        log.info("Binding : {}", (Object)binding);
        RpcServer server = DefaultRpcServer.create((RabbitMQOptions)RpcServerExample.options(), (Binding)binding);
        server.respondAsync(RpcServerExample::handler);
        FunctionMetricsPublisher.consumer(RpcServerExample::metrics).withInterval(1L, TimeUnit.SECONDS).withResetOnReporting(false).build().start();
        Thread.currentThread().join();
    }

    private static void metrics(Object o) {
        System.out.println("Metrics Info : " + o);
    }

    private static LogDetailResponse handler(LogDetailRequest log) {
        return new LogDetailResponse("response", "info");
    }

    private static Binding bind() {
        return ((BindingBuilder.DirectExchangeRoutingKeyConfigurer)BindingBuilder.bind((String)"rpc.request.log").to(new DirectExchange("exchange.rpc.logs")).withPrefetchCount(1)).build();
    }
}

