/*
 * Decompiled with CFR 0.152.
 */
package com.adelean.inject.resources.core;

import com.adelean.inject.resources.core.Parsable;
import com.adelean.inject.resources.core.Resource;
import com.adelean.inject.resources.core.ResourceAsLines;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ResourceAsReader
implements Parsable<Reader>,
AutoCloseable {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final Resource delegate;
    private final Charset charset;
    private BufferedReader reader;

    ResourceAsReader(Resource resource) {
        this(resource, DEFAULT_CHARSET);
    }

    ResourceAsReader(Resource resource, Charset charset) {
        this.delegate = resource;
        this.charset = charset;
    }

    public BufferedReader reader() {
        return this.delegate.resourceLoader.resourceReader(this.delegate.resourcePath, this.charset);
    }

    @Override
    public BufferedReader get() {
        return this.reader();
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public ResourceAsLines asLines() {
        return new ResourceAsLines(this);
    }
}

