/*
 * Decompiled with CFR 0.152.
 */
package io.hosuaby.inject.resources.commons;

import io.hosuaby.inject.resources.annotations.SupportedTypes;
import io.hosuaby.inject.resources.commons.ClassSupport;
import io.hosuaby.inject.resources.commons.Errors;
import io.hosuaby.inject.resources.core.helpers.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;

public final class FieldAsserts {
    private static final String ERR_PRIVATE_FIELD = "@%s field [%s] must not be private.";
    private static final String ERR_UNSUPPORTED_TYPE = "@%s cannot be resolved on %s of type %s. Supported types are:\n%s";
    private static final String ERR_TARGET_NOT_ARRAY_OR_COLLECTION = "@%s cannot be resolved on %s of type %s. %s must be array or collection.";

    private FieldAsserts() {
    }

    public static void assertNonPrivate(Field field, Class<?> annotationType) {
        if (Modifier.isPrivate(field.getModifiers())) {
            throw new RuntimeException(String.format(ERR_PRIVATE_FIELD, annotationType.getSimpleName(), field.getName()));
        }
    }

    public static void assertSupportedType(Field field, Class<? extends Annotation> annotationType) {
        Class<?> fieldType = field.getType();
        FieldAsserts.assertSupportedType("field", fieldType, annotationType);
    }

    public static void assertSupportedType(Parameter parameter, Class<? extends Annotation> annotationType) {
        Class<?> parameterType = parameter.getType();
        FieldAsserts.assertSupportedType("parameter", parameterType, annotationType);
    }

    private static void assertSupportedType(String target, Class<?> targetType, Class<? extends Annotation> annotationType) {
        SupportedTypes supportedTypes = annotationType.getAnnotation(SupportedTypes.class);
        if (supportedTypes == null) {
            return;
        }
        for (Class<?> supportedType : supportedTypes.value()) {
            if (!targetType.isAssignableFrom(supportedType)) continue;
            return;
        }
        throw new RuntimeException(String.format(ERR_UNSUPPORTED_TYPE, annotationType.getSimpleName(), target, targetType.getName(), Errors.typesToString(supportedTypes.value())));
    }

    public static void assertArrayOrCollection(String target, Class<?> targetType, Class<? extends Annotation> annotationType) {
        boolean valid;
        boolean bl = valid = ClassSupport.isArray(targetType) || ClassSupport.isCollection(targetType);
        if (!valid) {
            throw new RuntimeException(String.format(ERR_TARGET_NOT_ARRAY_OR_COLLECTION, annotationType.getSimpleName(), target, targetType.getName(), StringUtils.ucfirst((String)target)));
        }
    }
}

