/*
 * Decompiled with CFR 0.152.
 */
package io.hosuaby.inject.resources.spring.beans;

import io.hosuaby.inject.resources.spring.core.AbstractResourceInjectedElement;
import io.hosuaby.inject.resources.spring.core.Annotations;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.SmartInstantiationAwareBeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class InjectedResourcesAnnotationBeanPostProcessor
implements SmartInstantiationAwareBeanPostProcessor,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public PropertyValues postProcessProperties(PropertyValues pvs, Object bean, String beanName) throws BeansException {
        InjectionMetadata metadata = this.buildAutowiringMetadata(bean.getClass());
        try {
            metadata.inject(bean, beanName, pvs);
        }
        catch (BeanCreationException beanCreationException) {
            throw beanCreationException;
        }
        catch (Throwable throwable) {
            throw new BeanCreationException(beanName, "Injection of autowired dependencies failed", throwable);
        }
        return pvs;
    }

    private InjectionMetadata buildAutowiringMetadata(Class<?> clazz) {
        if (!AnnotationUtils.isCandidateClass(clazz, Annotations.RESOURCE_ANNOTATIONS)) {
            return InjectionMetadata.EMPTY;
        }
        ArrayList elements = new ArrayList();
        Class<?> targetClass = clazz;
        do {
            ArrayList currElements = new ArrayList();
            ReflectionUtils.doWithLocalFields(targetClass, field -> {
                Annotation resourceAnnotation = Annotations.findSingleResourceAnnotation(field);
                if (resourceAnnotation != null) {
                    AbstractResourceInjectedElement<?> resourceFieldElement = AbstractResourceInjectedElement.injectorForResource(resourceAnnotation, field, this.applicationContext);
                    currElements.add(resourceFieldElement);
                }
            });
            ReflectionUtils.doWithLocalMethods(targetClass, method -> {
                Method bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)method);
                if (!BridgeMethodResolver.isVisibilityBridgeMethodPair((Method)method, (Method)bridgedMethod)) {
                    return;
                }
                Annotation resourceAnnotation = Annotations.findSingleResourceAnnotation(bridgedMethod);
                if (resourceAnnotation != null && method.equals(ClassUtils.getMostSpecificMethod((Method)method, (Class)clazz))) {
                    AbstractResourceInjectedElement<?> resourceMethodElement = AbstractResourceInjectedElement.injectorForResource(resourceAnnotation, method, this.applicationContext);
                    currElements.add(resourceMethodElement);
                }
            });
            elements.addAll(0, currElements);
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        return InjectionMetadata.forElements(elements, clazz);
    }
}

