/*
 * Decompiled with CFR 0.152.
 */
package io.hosuaby.inject.resources.spring.beans;

import io.hosuaby.inject.resources.spring.core.AbstractResourceInjectedElement;
import io.hosuaby.inject.resources.spring.core.Annotations;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.NotFoundException;
import javassist.bytecode.ParameterAnnotationsAttribute;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class InjectedResourcesBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
ApplicationContextAware {
    private static final ClassPool CLASS_POOL = ClassPool.getDefault();
    private ApplicationContext applicationContext;

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Stream.of(beanFactory.getBeanDefinitionNames()).map(arg_0 -> ((ConfigurableListableBeanFactory)beanFactory).getBeanDefinition(arg_0)).forEach(this::processBeanDefinition);
    }

    void processBeanDefinition(BeanDefinition beanDefinition) {
        InjectedResourcesBeanFactoryPostProcessor.findBeanClass(beanDefinition).map(this::getInjectedParameters).orElseGet(Collections::emptyMap).forEach((arg_0, arg_1) -> ((ConstructorArgumentValues)beanDefinition.getConstructorArgumentValues()).addIndexedArgumentValue(arg_0, arg_1));
    }

    Map<Integer, Object> getInjectedParameters(Class<?> beanClass) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = beanClass.getConstructors()) {
            Parameter[] parameters = constructor.getParameters();
            HashMap<Integer, Object> parameterMap = new HashMap<Integer, Object>();
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter = parameters[i];
                Annotation resourceAnnotation = Annotations.findSingleResourceAnnotation(parameter);
                if (resourceAnnotation == null) continue;
                Annotations.assertNoOtherAnnotations(parameter, resourceAnnotation);
                Object value = this.resolveResourceArgument(parameter.getParameterizedType(), resourceAnnotation);
                parameterMap.put(i, value);
            }
            if (parameterMap.isEmpty()) continue;
            return parameterMap;
        }
        return Collections.emptyMap();
    }

    Object resolveResourceArgument(Type valueType, Annotation resourceAnnotation) throws BeansException {
        AbstractResourceInjectedElement<?> injectedElement = AbstractResourceInjectedElement.injectorForResource(resourceAnnotation, null, this.applicationContext);
        return injectedElement.valueToInject(valueType, resourceAnnotation);
    }

    static Optional<Class<?>> findBeanClass(BeanDefinition beanDefinition) {
        Class<?> beanClass = beanDefinition.getResolvableType().getRawClass();
        String beanClassName = beanDefinition.getBeanClassName();
        if (beanClass != null) {
            return Optional.of(beanClass);
        }
        if (beanClassName != null && InjectedResourcesBeanFactoryPostProcessor.hasResourcesInjectedInConstructor(beanClassName)) {
            try {
                beanClass = Class.forName(beanClassName);
                return Optional.of(beanClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new FatalBeanException(classNotFoundException.getMessage(), (Throwable)classNotFoundException);
            }
        }
        return Optional.empty();
    }

    static boolean hasResourcesInjectedInConstructor(String beanClassName) {
        try {
            CtConstructor[] constructors;
            CtClass ctClass = CLASS_POOL.get(beanClassName);
            for (CtConstructor constructor : constructors = ctClass.getDeclaredConstructors()) {
                javassist.bytecode.annotation.Annotation[][] annotations;
                ParameterAnnotationsAttribute parameterAnnotationsAttribute = (ParameterAnnotationsAttribute)constructor.getMethodInfo().getAttribute("RuntimeVisibleParameterAnnotations");
                if (parameterAnnotationsAttribute == null) continue;
                javassist.bytecode.annotation.Annotation[][] annotationArray = annotations = parameterAnnotationsAttribute.getAnnotations();
                int n = annotationArray.length;
                for (int i = 0; i < n; ++i) {
                    javassist.bytecode.annotation.Annotation[] parameterAnnotations;
                    for (javassist.bytecode.annotation.Annotation annotation : parameterAnnotations = annotationArray[i]) {
                        if (!Annotations.isResourceAnnotation(annotation.getTypeName())) continue;
                        return true;
                    }
                }
            }
        }
        catch (NotFoundException classNotFoundException) {
            throw new FatalBeanException(classNotFoundException.getMessage(), (Throwable)classNotFoundException);
        }
        return false;
    }
}

