/*
 * Decompiled with CFR 0.152.
 */
package io.hosuaby.inject.resources.spring.core;

import io.hosuaby.inject.resources.commons.FieldAsserts;
import io.hosuaby.inject.resources.spring.EnableResourceInjection;
import io.hosuaby.inject.resources.spring.core.Annotations;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractResourceInjectedElement<A extends Annotation>
extends InjectionMetadata.InjectedElement {
    protected static final Reflections REFLECTIONS = new Reflections((Configuration)new ConfigurationBuilder().forPackage(EnableResourceInjection.class.getPackage().getName(), new ClassLoader[0]).setClassLoaders(new ClassLoader[]{EnableResourceInjection.class.getClassLoader()}));
    private static final Map<Class<? extends Annotation>, Class<? extends AbstractResourceInjectedElement<? extends Annotation>>> INJECTED_ELEMENT_CLASSES = AbstractResourceInjectedElement.getAllFieldElements();
    protected final A resourceAnnotation;
    protected final ApplicationContext applicationContext;

    protected AbstractResourceInjectedElement(Member member, A resourceAnnotation, ApplicationContext applicationContext) {
        super(member, null);
        this.resourceAnnotation = resourceAnnotation;
        this.applicationContext = applicationContext;
    }

    public final void inject(@NotNull Object bean, @Nullable String beanName, @Nullable PropertyValues pvs) throws Throwable {
        if (this.member instanceof Field) {
            this.injectField(bean);
        } else if (this.member instanceof Method) {
            this.injectMethod(bean);
        }
    }

    protected void injectField(Object bean) throws Throwable {
        Field field = (Field)this.member;
        this.assertValidField(field);
        Type valueType = field.getGenericType();
        Object value = this.valueToInject(valueType, this.resourceAnnotation);
        ReflectionUtils.makeAccessible((Field)field);
        field.set(bean, value);
    }

    protected void injectMethod(Object bean) throws Throwable {
        Method method = (Method)this.member;
        this.assertValidMethod(method);
        Type valueType = method.getGenericParameterTypes()[0];
        Object value = this.valueToInject(valueType, this.resourceAnnotation);
        try {
            ReflectionUtils.makeAccessible((Method)method);
            method.invoke(bean, value);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
    }

    protected void assertValidField(Field field) {
        Class<? extends Annotation> annotationType = this.resourceAnnotation.annotationType();
        Annotations.assertNoOtherAnnotations(field, this.resourceAnnotation);
        FieldAsserts.assertSupportedType(field, annotationType);
    }

    protected void assertValidMethod(Method method) {
        Annotations.assertNoOtherAnnotations(method, this.resourceAnnotation);
        Class<? extends Annotation> annotationType = this.resourceAnnotation.annotationType();
        if (method.getParameterCount() != 1) {
            throw new RuntimeException(String.format("Method %s annotated with @%s must have exactly one parameter", method.getName(), annotationType.getSimpleName()));
        }
        Parameter parameter = method.getParameters()[0];
        FieldAsserts.assertSupportedType(parameter, annotationType);
    }

    public abstract Object valueToInject(Type var1, A var2);

    public static AbstractResourceInjectedElement<?> injectorForResource(Annotation resourceAnnotation, Member member, ApplicationContext applicationContext) {
        Class<? extends AbstractResourceInjectedElement<? extends Annotation>> resourceFieldElementClass = INJECTED_ELEMENT_CLASSES.get(resourceAnnotation.annotationType());
        try {
            Constructor<?> constructor = resourceFieldElementClass.getConstructors()[0];
            constructor.setAccessible(true);
            return (AbstractResourceInjectedElement)((Object)constructor.newInstance(member, resourceAnnotation, applicationContext));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
    }

    static Map<Class<? extends Annotation>, Class<? extends AbstractResourceInjectedElement<? extends Annotation>>> getAllFieldElements() {
        return REFLECTIONS.getSubTypesOf(AbstractResourceInjectedElement.class).stream().filter(clazz -> Modifier.isPublic(clazz.getModifiers())).map(clazz -> clazz).collect(Collectors.toMap(clazz -> (Class)((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments()[0], clazz -> clazz));
    }
}

