/*
 * Decompiled with CFR 0.152.
 */
package io.hosuaby.inject.resources.spring.json;

import io.hosuaby.inject.resources.commons.ClasspathSupport;
import io.hosuaby.inject.resources.spring.core.AbstractResourceInjectedElement;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.Nullable;

abstract class AbstractJsonResourceInjectedElement<A extends Annotation>
extends AbstractResourceInjectedElement<A> {
    private static final String ERR_NO_PARSER_BEAN = "No JSON parser bean was found.\nBean of any of following types is required:\n\t- com.fasterxml.jackson.databind.ObjectMapper\n\t- com.google.gson.Gson";

    protected AbstractJsonResourceInjectedElement(Member member, A resourceAnnotation, ApplicationContext applicationContext) {
        super(member, resourceAnnotation, applicationContext);
    }

    protected Object findParser(@Nullable String parserBeanName) {
        Object parser = null;
        if (parserBeanName != null) {
            parser = this.applicationContext.getBean(parserBeanName);
        } else {
            if (ClasspathSupport.isJackson2Present()) {
                Class jacksonMapperClass = AbstractResourceInjectedElement.REFLECTIONS.forClass("com.fasterxml.jackson.databind.ObjectMapper", new ClassLoader[0]);
                try {
                    parser = this.applicationContext.getBean(jacksonMapperClass);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (parser == null && ClasspathSupport.isGsonPresent()) {
                Class gsonClass = AbstractResourceInjectedElement.REFLECTIONS.forClass("com.google.gson.Gson", new ClassLoader[0]);
                try {
                    parser = this.applicationContext.getBean(gsonClass);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (parser != null) {
            return parser;
        }
        throw new NoSuchBeanDefinitionException("", ERR_NO_PARSER_BEAN);
    }
}

