/*
 * Decompiled with CFR 0.152.
 */
package io.hosuaby.inject.resources.spring.json;

import io.hosuaby.inject.resources.commons.AnnotationSupport;
import io.hosuaby.inject.resources.commons.ClassSupport;
import io.hosuaby.inject.resources.commons.CollectionFactory;
import io.hosuaby.inject.resources.core.InjectResources;
import io.hosuaby.inject.resources.core.ResourceAsLines;
import io.hosuaby.inject.resources.core.function.ThrowingFunction;
import io.hosuaby.inject.resources.core.helpers.StringUtils;
import io.hosuaby.inject.resources.parsers.Parsers;
import io.hosuaby.inject.resources.spring.JsonLinesResource;
import io.hosuaby.inject.resources.spring.core.Asserts;
import io.hosuaby.inject.resources.spring.json.AbstractJsonResourceInjectedElement;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.stream.Stream;
import org.springframework.context.ApplicationContext;

public final class JsonLinesResourceInjectedElement
extends AbstractJsonResourceInjectedElement<JsonLinesResource> {
    public JsonLinesResourceInjectedElement(Member member, JsonLinesResource resourceAnnotation, ApplicationContext applicationContext) {
        super(member, resourceAnnotation, applicationContext);
    }

    @Override
    protected void assertValidField(Field field) {
        super.assertValidField(field);
        Asserts.assertArrayOrCollection("field", field.getGenericType(), JsonLinesResource.class);
    }

    @Override
    protected void assertValidMethod(Method method) {
        super.assertValidMethod(method);
        Parameter parameter = method.getParameters()[0];
        Asserts.assertArrayOrCollection("parameter", parameter.getParameterizedType(), JsonLinesResource.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object valueToInject(Type valueType, JsonLinesResource resourceAnnotation) {
        String path = AnnotationSupport.getFrom(resourceAnnotation);
        Charset charset = Charset.forName(resourceAnnotation.charset());
        String parserBeanName = StringUtils.blankToNull((String)resourceAnnotation.parserBean());
        Type elementType = ClassSupport.elementType(valueType);
        Object parser = this.findParser(parserBeanName);
        ThrowingFunction parseFunction = Parsers.parseFunction(parser, elementType);
        try (ResourceAsLines resource = InjectResources.resource().withPath(path, new String[0]).asLines(charset);){
            Stream items = resource.parseLinesChecked(line -> {
                StringReader lineReader = new StringReader((String)line);
                return parseFunction.apply((Object)lineReader);
            });
            if (ClassSupport.isArray(valueType)) {
                A[] AArray = items.toArray(length -> (Object[])Array.newInstance((Class)elementType, length));
                return AArray;
            }
            if (!ClassSupport.isCollection(valueType)) return null;
            Collection collection = CollectionFactory.newCollection((ParameterizedType)valueType);
            items.forEach(collection::add);
            Collection collection2 = collection;
            return collection2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

