/*
 * Decompiled with CFR 0.152.
 */
package io.hosuaby.inject.resources.spring.json;

import io.hosuaby.inject.resources.commons.AnnotationSupport;
import io.hosuaby.inject.resources.core.InjectResources;
import io.hosuaby.inject.resources.core.function.ThrowingFunction;
import io.hosuaby.inject.resources.core.helpers.StringUtils;
import io.hosuaby.inject.resources.parsers.Parsers;
import io.hosuaby.inject.resources.spring.JsonResource;
import io.hosuaby.inject.resources.spring.json.AbstractJsonResourceInjectedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import org.springframework.context.ApplicationContext;

public final class JsonResourceInjectedElement
extends AbstractJsonResourceInjectedElement<JsonResource> {
    public JsonResourceInjectedElement(Member member, JsonResource resourceAnnotation, ApplicationContext applicationContext) {
        super(member, resourceAnnotation, applicationContext);
    }

    @Override
    public Object valueToInject(Type valueType, JsonResource resourceAnnotation) {
        String path = AnnotationSupport.getFrom(resourceAnnotation);
        Charset charset = Charset.forName(resourceAnnotation.charset());
        String parserBeanName = StringUtils.blankToNull((String)resourceAnnotation.parserBean());
        Object parser = this.findParser(parserBeanName);
        ThrowingFunction parseFunction = Parsers.parseFunction(parser, valueType);
        return InjectResources.resource().withPath(path, new String[0]).asReader(charset).parseChecked(parseFunction);
    }
}

