/*
 * Decompiled with CFR 0.152.
 */
package io.hosuaby.inject.resources.spring.yaml;

import io.hosuaby.inject.resources.commons.AnnotationSupport;
import io.hosuaby.inject.resources.commons.ClassSupport;
import io.hosuaby.inject.resources.commons.CollectionFactory;
import io.hosuaby.inject.resources.core.InjectResources;
import io.hosuaby.inject.resources.core.ResourceAsReader;
import io.hosuaby.inject.resources.core.helpers.StringUtils;
import io.hosuaby.inject.resources.spring.YamlDocumentsResource;
import io.hosuaby.inject.resources.spring.core.AbstractResourceInjectedElement;
import io.hosuaby.inject.resources.spring.core.Asserts;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.stream.StreamSupport;
import org.springframework.context.ApplicationContext;
import org.yaml.snakeyaml.Yaml;

public final class YamlDocumentsResourceInjectElement
extends AbstractResourceInjectedElement<YamlDocumentsResource> {
    public YamlDocumentsResourceInjectElement(Member member, YamlDocumentsResource resourceAnnotation, ApplicationContext applicationContext) {
        super(member, resourceAnnotation, applicationContext);
    }

    @Override
    protected void assertValidField(Field field) {
        super.assertValidField(field);
        Asserts.assertArrayOrCollection("field", field.getGenericType(), YamlDocumentsResource.class);
    }

    @Override
    protected void assertValidMethod(Method method) {
        super.assertValidMethod(method);
        Parameter parameter = method.getParameters()[0];
        Asserts.assertArrayOrCollection("parameter", parameter.getParameterizedType(), YamlDocumentsResource.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object valueToInject(Type valueType, YamlDocumentsResource resourceAnnotation) {
        String path = AnnotationSupport.getFrom(resourceAnnotation);
        Charset charset = Charset.forName(resourceAnnotation.charset());
        Yaml yaml = StringUtils.isNotBlank((String)resourceAnnotation.yamlBean()) ? (Yaml)this.applicationContext.getBean(resourceAnnotation.yamlBean(), Yaml.class) : (Yaml)this.applicationContext.getBean(Yaml.class);
        Class<?> elementType = ClassSupport.fromType(ClassSupport.elementType(valueType));
        try (ResourceAsReader resource = InjectResources.resource().withPath(path, new String[0]).asReader(charset);){
            Iterable documents = yaml.loadAll((Reader)resource.reader());
            if (ClassSupport.isArray(valueType)) {
                A[] AArray = StreamSupport.stream(documents.spliterator(), false).toArray(length -> (Object[])Array.newInstance(elementType, length));
                return AArray;
            }
            if (!ClassSupport.isCollection(valueType)) return null;
            Collection collection = CollectionFactory.newCollection((ParameterizedType)valueType);
            documents.forEach(collection::add);
            Collection collection2 = collection;
            return collection2;
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }
}

