/*
 * Decompiled with CFR 0.152.
 */
package io.humble.ferry;

import io.humble.ferry.Ferry;
import io.humble.ferry.JNIEnv;
import io.humble.ferry.JNILibraryLoader;
import io.humble.ferry.JNIManifest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JNILibrary
implements Comparable<JNILibrary> {
    private static final Logger log = LoggerFactory.getLogger(JNILibrary.class);
    private static final String HUMBLE_TEMP_EXTENSION = ".humble";
    private static final Map<String, List<JNIManifest>> mManifestLists = new HashMap<String, List<JNIManifest>>();
    private static final Map<String, JNILibrary> mAttemptedLibraries = new HashMap<String, JNILibrary>();
    private static final Object mLock = new Object();
    private final String mName;
    private final Long mVersion;
    private boolean mLoadAttempted;
    private boolean mLoadSuccessful;
    private static JNIEnv.OSFamily mOSFamily;

    private static List<JNIManifest> getNativeManifests(String appName) {
        List<JNIManifest> cached = mManifestLists.get(appName);
        if (cached != null) {
            return cached;
        }
        LinkedList<JNIManifest> retval = new LinkedList<JNIManifest>();
        ClassLoader loader = JNILibrary.class.getClassLoader();
        try {
            Enumeration<URL> manifests = loader.getResources("META-INF/MANIFEST.MF");
            while (manifests.hasMoreElements()) {
                JNIManifest manifest;
                Manifest jarManifest;
                URL url = manifests.nextElement();
                log.trace("Examining manifest: {}", (Object)url);
                InputStream stream = url.openStream();
                if (stream == null || (jarManifest = new Manifest(stream)) == null || (manifest = JNIManifest.create(url, appName, jarManifest)) == null) continue;
                log.trace("found manifest: {}; url: {}", (Object)manifest, (Object)url);
                retval.add(manifest);
            }
        }
        catch (IOException e) {
            log.debug("could not open manifest: {}", (Throwable)e);
        }
        mManifestLists.put(appName, retval);
        return retval;
    }

    public JNILibrary(String name, Long version) {
        if (name == null || name.length() <= 0) {
            throw new IllegalArgumentException("need a valid name");
        }
        this.mName = name;
        this.mVersion = version;
        this.mLoadAttempted = false;
        this.mLoadSuccessful = false;
    }

    public String getName() {
        return this.mName;
    }

    public Long getVersion() {
        return this.mVersion;
    }

    public boolean isLoadAttempted() {
        return this.mLoadAttempted;
    }

    public boolean isLoadSuccessful() {
        return this.mLoadSuccessful;
    }

    public String toString() {
        return super.toString() + "[ name=" + this.mName + "; version=" + this.mVersion + "; ]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(String appname, JNILibrary library) {
        Object object = mLock;
        synchronized (object) {
            JNILibrary.deleteTemporaryFiles();
            try {
                library.load(appname);
            }
            catch (UnsatisfiedLinkError e) {
                JNILibraryLoader.loadLibrary(library.getName(), library.getVersion());
            }
        }
    }

    private void load(String appName) throws UnsatisfiedLinkError, SecurityException {
        if (this.mLoadAttempted) {
            if (this.mLoadSuccessful) {
                return;
            }
            throw new UnsatisfiedLinkError("already attempted and failed to load library: " + this.getName());
        }
        this.mLoadAttempted = true;
        this.loadFromClasspath(appName);
        this.mLoadSuccessful = false;
    }

    private void loadFromClasspath(String appName) {
        JNILibrary priorAttempt = mAttemptedLibraries.get(this.getName());
        if (priorAttempt != null) {
            if (priorAttempt.mLoadSuccessful) {
                return;
            }
            throw new UnsatisfiedLinkError("previously attempted to load library and it failed: " + priorAttempt.getName());
        }
        List<String> libraryURLs = this.generateCandidateLibraryURLs(appName, this.getName());
        for (String url : libraryURLs) {
            if (!this.unpackLibrary(url)) continue;
            return;
        }
        throw new UnsatisfiedLinkError("could not load library: " + this.getName());
    }

    private void doJNILoad(String url) {
        try {
            log.trace("Attempt: library load of library: {}; url: {}", new Object[]{this.getName(), url});
            System.load(url);
            log.trace("Success: library load of library: {}; url: {}", new Object[]{this.getName(), url});
        }
        catch (UnsatisfiedLinkError e) {
            log.debug("Failure: library load of library: {}; url: {}; error: {}", new Object[]{this.getName(), url, e});
            throw e;
        }
        catch (SecurityException e) {
            log.warn("Failure: library load of library: {}; url: {}; error: {}", new Object[]{this.getName(), url, e});
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unpackLibrary(String path) {
        boolean retval = false;
        try {
            Enumeration<URL> c = JNILibrary.class.getClassLoader().getResources(path);
            while (c.hasMoreElements()) {
                File lib;
                URL url = c.nextElement();
                log.trace("path: {}; url: {}", (Object)path, (Object)url);
                if (url == null) {
                    return false;
                }
                boolean unpacked = false;
                if (url.getProtocol().toLowerCase().equals("file")) {
                    try {
                        lib = new File(new URI(url.toString()));
                    }
                    catch (URISyntaxException e) {
                        lib = new File(url.getPath());
                    }
                    if (lib.exists()) continue;
                    log.error("Unpacked library not unpacked correctedly;  url: {}", (Object)url);
                    continue;
                }
                if (!url.getProtocol().toLowerCase().equals("jar")) continue;
                InputStream stream = url.openStream();
                if (stream == null) {
                    log.error("could not get stream for resource: {}", (Object)url.getPath());
                    continue;
                }
                FileOutputStream out = null;
                try {
                    File dir = JNILibrary.getTmpDir();
                    lib = File.createTempFile("humble", JNIEnv.getEnv().getOSFamily() == JNIEnv.OSFamily.WINDOWS ? ".dll" : null, dir);
                    lib.deleteOnExit();
                    out = new FileOutputStream(lib);
                    int bytesRead = 0;
                    byte[] buffer = new byte[2048];
                    while ((bytesRead = stream.read(buffer, 0, buffer.length)) > 0) {
                        out.write(buffer, 0, bytesRead);
                    }
                    unpacked = true;
                }
                catch (IOException e) {
                    log.error("could not create temp file: {}", (Throwable)e);
                    continue;
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {}
                    if (out == null) continue;
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                    continue;
                }
                try {
                    this.doJNILoad(lib.getAbsolutePath());
                    retval = true;
                    break;
                }
                catch (UnsatisfiedLinkError e) {}
                continue;
                finally {
                    if (!unpacked) continue;
                    this.deleteUnpackedFile(lib.getAbsolutePath());
                }
            }
        }
        catch (IOException e1) {
            retval = false;
        }
        return retval;
    }

    private void deleteUnpackedFile(String absolutePath) {
        File file = new File(absolutePath);
        if (file.delete()) {
            return;
        }
        String markerName = file.getName() + HUMBLE_TEMP_EXTENSION;
        try {
            File marker = new File(file.getParentFile(), markerName);
            marker.createNewFile();
        }
        catch (IOException e) {
            log.error("could not create marker file: {}; error: {}", (Object)markerName, (Object)e);
        }
    }

    private static File getTmpDir() {
        File tmpdir = new File(System.getProperty("java.io.tmpdir"));
        return tmpdir;
    }

    private static void deleteTemporaryFiles() {
        File[] markers;
        File dir = JNILibrary.getTmpDir();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(JNILibrary.HUMBLE_TEMP_EXTENSION);
            }
        };
        for (File marker : markers = dir.listFiles(filter)) {
            String markerName = marker.getName();
            String libName = markerName.substring(0, markerName.length() - HUMBLE_TEMP_EXTENSION.length());
            File lib = new File(marker.getParentFile(), libName);
            if (lib.exists() && !lib.delete()) continue;
            marker.delete();
        }
    }

    private List<String> generateCandidateLibraryURLs(String appName, String libname) {
        LinkedList<String> retval = new LinkedList<String>();
        List<JNIManifest> manifests = JNILibrary.getNativeManifests(appName);
        for (JNIManifest manifest : manifests) {
            this.generateLibnames(retval, manifest.getPath(), libname);
        }
        this.generateLibnames(retval, "/", libname);
        return retval;
    }

    void setOSFamily(JNIEnv.OSFamily os) {
        mOSFamily = os;
    }

    JNIEnv.OSFamily getOSFamily() {
        return mOSFamily;
    }

    private void generateLibnames(List<String> list, String path, String libname) {
        String[] suffixes;
        String[] prefixes;
        switch (this.getOSFamily()) {
            case UNKNOWN: 
            case LINUX: {
                prefixes = new String[]{"lib", ""};
                suffixes = new String[]{".so"};
                break;
            }
            case WINDOWS: {
                prefixes = new String[]{"lib", "", "cyg"};
                suffixes = new String[]{"-" + Ferry.getMajorVersion() + ".dll", ".dll"};
                break;
            }
            case MAC: {
                prefixes = new String[]{"lib", ""};
                suffixes = new String[]{".dylib"};
                break;
            }
            default: {
                prefixes = null;
                suffixes = null;
            }
        }
        String dirSeparator = "/";
        if (path.length() > 0 && !path.endsWith("/")) {
            path = path + "/";
        }
        for (String suffix : suffixes) {
            for (String prefix : prefixes) {
                list.add(path + prefix + libname + suffix);
            }
        }
    }

    @Override
    public int compareTo(JNILibrary o) {
        if (o == null) {
            return -1;
        }
        int retval = this.mName.compareTo(o.mName);
        if (retval == 0) {
            if (this.mVersion == null) {
                if (o.mVersion != null) {
                    retval = 1;
                }
            } else {
                retval = o.mVersion == null ? -1 : this.mVersion.compareTo(o.mVersion);
            }
        }
        return retval;
    }

    static {
        JNILibrary.deleteTemporaryFiles();
        mOSFamily = JNIEnv.getEnv().getOSFamily();
    }
}

