/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.ferry.RefCounted;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class AudioChannel
extends RefCounted {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected AudioChannel(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.AudioChannel_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected AudioChannel(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.AudioChannel_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(AudioChannel obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public AudioChannel copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new AudioChannel(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof AudioChannel) {
            equal = ((AudioChannel)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public static long getChannelBitmask(String name) {
        return VideoJNI.AudioChannel_getChannelBitmask(name);
    }

    public static String getChannelLayoutString(int numChannels, long layout) {
        return VideoJNI.AudioChannel_getChannelLayoutString(numChannels, layout);
    }

    public static int getNumChannelsInLayout(Layout layout) {
        return VideoJNI.AudioChannel_getNumChannelsInLayout(layout.swigValue());
    }

    public static Layout getDefaultLayout(int numChannels) {
        return Layout.swigToEnum(VideoJNI.AudioChannel_getDefaultLayout(numChannels));
    }

    public static int getIndexOfChannelInLayout(Layout layout, Type channel) {
        return VideoJNI.AudioChannel_getIndexOfChannelInLayout(layout.swigValue(), channel.swigValue());
    }

    public static Type getChannelFromLayoutAtIndex(Layout layout, int index) {
        return Type.swigToEnum(VideoJNI.AudioChannel_getChannelFromLayoutAtIndex(layout.swigValue(), index));
    }

    public static String getChannelName(Type channel) {
        return VideoJNI.AudioChannel_getChannelName(channel.swigValue());
    }

    public static String getChannelDescription(Type channel) {
        return VideoJNI.AudioChannel_getChannelDescription(channel.swigValue());
    }

    public static String getLayoutName(Layout layout) {
        return VideoJNI.AudioChannel_getLayoutName(layout.swigValue());
    }

    public static enum Layout {
        CH_LAYOUT_UNKNOWN(VideoJNI.AudioChannel_CH_LAYOUT_UNKNOWN_get()),
        CH_LAYOUT_NATIVE(VideoJNI.AudioChannel_CH_LAYOUT_NATIVE_get()),
        CH_LAYOUT_MONO(VideoJNI.AudioChannel_CH_LAYOUT_MONO_get()),
        CH_LAYOUT_STEREO(VideoJNI.AudioChannel_CH_LAYOUT_STEREO_get()),
        CH_LAYOUT_2POINT1(VideoJNI.AudioChannel_CH_LAYOUT_2POINT1_get()),
        CH_LAYOUT_2_1(VideoJNI.AudioChannel_CH_LAYOUT_2_1_get()),
        CH_LAYOUT_SURROUND(VideoJNI.AudioChannel_CH_LAYOUT_SURROUND_get()),
        CH_LAYOUT_3POINT1(VideoJNI.AudioChannel_CH_LAYOUT_3POINT1_get()),
        CH_LAYOUT_4POINT0(VideoJNI.AudioChannel_CH_LAYOUT_4POINT0_get()),
        CH_LAYOUT_4POINT1(VideoJNI.AudioChannel_CH_LAYOUT_4POINT1_get()),
        CH_LAYOUT_2_2(VideoJNI.AudioChannel_CH_LAYOUT_2_2_get()),
        CH_LAYOUT_QUAD(VideoJNI.AudioChannel_CH_LAYOUT_QUAD_get()),
        CH_LAYOUT_5POINT0(VideoJNI.AudioChannel_CH_LAYOUT_5POINT0_get()),
        CH_LAYOUT_5POINT1(VideoJNI.AudioChannel_CH_LAYOUT_5POINT1_get()),
        CH_LAYOUT_5POINT0_BACK(VideoJNI.AudioChannel_CH_LAYOUT_5POINT0_BACK_get()),
        CH_LAYOUT_5POINT1_BACK(VideoJNI.AudioChannel_CH_LAYOUT_5POINT1_BACK_get()),
        CH_LAYOUT_6POINT0(VideoJNI.AudioChannel_CH_LAYOUT_6POINT0_get()),
        CH_LAYOUT_6POINT0_FRONT(VideoJNI.AudioChannel_CH_LAYOUT_6POINT0_FRONT_get()),
        CH_LAYOUT_HEXAGONAL(VideoJNI.AudioChannel_CH_LAYOUT_HEXAGONAL_get()),
        CH_LAYOUT_6POINT1(VideoJNI.AudioChannel_CH_LAYOUT_6POINT1_get()),
        CH_LAYOUT_6POINT1_BACK(VideoJNI.AudioChannel_CH_LAYOUT_6POINT1_BACK_get()),
        CH_LAYOUT_6POINT1_FRONT(VideoJNI.AudioChannel_CH_LAYOUT_6POINT1_FRONT_get()),
        CH_LAYOUT_7POINT0(VideoJNI.AudioChannel_CH_LAYOUT_7POINT0_get()),
        CH_LAYOUT_7POINT0_FRONT(VideoJNI.AudioChannel_CH_LAYOUT_7POINT0_FRONT_get()),
        CH_LAYOUT_7POINT1(VideoJNI.AudioChannel_CH_LAYOUT_7POINT1_get()),
        CH_LAYOUT_7POINT1_WIDE(VideoJNI.AudioChannel_CH_LAYOUT_7POINT1_WIDE_get()),
        CH_LAYOUT_7POINT1_WIDE_BACK(VideoJNI.AudioChannel_CH_LAYOUT_7POINT1_WIDE_BACK_get()),
        CH_LAYOUT_OCTAGONAL(VideoJNI.AudioChannel_CH_LAYOUT_OCTAGONAL_get()),
        CH_LAYOUT_STEREO_DOWNMIX(VideoJNI.AudioChannel_CH_LAYOUT_STEREO_DOWNMIX_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Layout swigToEnum(int swigValue) {
            Layout[] swigValues = (Layout[])Layout.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Layout swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Layout.class + " with value " + swigValue);
        }

        private Layout() {
            this.swigValue = SwigNext.next++;
        }

        private Layout(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Layout(Layout swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum Type {
        CH_UNKNOWN(VideoJNI.AudioChannel_CH_UNKNOWN_get()),
        CH_FRONT_LEFT(VideoJNI.AudioChannel_CH_FRONT_LEFT_get()),
        CH_FRONT_RIGHT(VideoJNI.AudioChannel_CH_FRONT_RIGHT_get()),
        CH_FRONT_CENTER(VideoJNI.AudioChannel_CH_FRONT_CENTER_get()),
        CH_LOW_FREQUENCY(VideoJNI.AudioChannel_CH_LOW_FREQUENCY_get()),
        CH_BACK_LEFT(VideoJNI.AudioChannel_CH_BACK_LEFT_get()),
        CH_BACK_RIGHT(VideoJNI.AudioChannel_CH_BACK_RIGHT_get()),
        CH_FRONT_LEFT_OF_CENTER(VideoJNI.AudioChannel_CH_FRONT_LEFT_OF_CENTER_get()),
        CH_FRONT_RIGHT_OF_CENTER(VideoJNI.AudioChannel_CH_FRONT_RIGHT_OF_CENTER_get()),
        CH_BACK_CENTER(VideoJNI.AudioChannel_CH_BACK_CENTER_get()),
        CH_SIDE_LEFT(VideoJNI.AudioChannel_CH_SIDE_LEFT_get()),
        CH_SIDE_RIGHT(VideoJNI.AudioChannel_CH_SIDE_RIGHT_get()),
        CH_TOP_CENTER(VideoJNI.AudioChannel_CH_TOP_CENTER_get()),
        CH_TOP_FRONT_LEFT(VideoJNI.AudioChannel_CH_TOP_FRONT_LEFT_get()),
        CH_TOP_FRONT_CENTER(VideoJNI.AudioChannel_CH_TOP_FRONT_CENTER_get()),
        CH_TOP_FRONT_RIGHT(VideoJNI.AudioChannel_CH_TOP_FRONT_RIGHT_get()),
        CH_TOP_BACK_LEFT(VideoJNI.AudioChannel_CH_TOP_BACK_LEFT_get()),
        CH_TOP_BACK_CENTER(VideoJNI.AudioChannel_CH_TOP_BACK_CENTER_get()),
        CH_TOP_BACK_RIGHT(VideoJNI.AudioChannel_CH_TOP_BACK_RIGHT_get()),
        CH_STEREO_LEFT(VideoJNI.AudioChannel_CH_STEREO_LEFT_get()),
        CH_STEREO_RIGHT(VideoJNI.AudioChannel_CH_STEREO_RIGHT_get()),
        CH_WIDE_LEFT(VideoJNI.AudioChannel_CH_WIDE_LEFT_get()),
        CH_WIDE_RIGHT(VideoJNI.AudioChannel_CH_WIDE_RIGHT_get()),
        CH_SURROUND_DIRECT_LEFT(VideoJNI.AudioChannel_CH_SURROUND_DIRECT_LEFT_get()),
        CH_SURROUND_DIRECT_RIGHT(VideoJNI.AudioChannel_CH_SURROUND_DIRECT_RIGHT_get()),
        CH_LOW_FREQUENCY_2(VideoJNI.AudioChannel_CH_LOW_FREQUENCY_2_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Type swigToEnum(int swigValue) {
            Type[] swigValues = (Type[])Type.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Type swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Type.class + " with value " + swigValue);
        }

        private Type() {
            this.swigValue = SwigNext.next++;
        }

        private Type(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Type(Type swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

