/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.ferry.RefCounted;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class AudioFormat
extends RefCounted {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected AudioFormat(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.AudioFormat_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected AudioFormat(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.AudioFormat_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(AudioFormat obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public AudioFormat copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new AudioFormat(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof AudioFormat) {
            equal = ((AudioFormat)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public static String getName(Type format) {
        return VideoJNI.AudioFormat_getName(format.swigValue());
    }

    public static Type getFormat(String name) {
        return Type.swigToEnum(VideoJNI.AudioFormat_getFormat(name));
    }

    public static Type getAlternateSampleFormat(Type sample_fmt, boolean planar) {
        return Type.swigToEnum(VideoJNI.AudioFormat_getAlternateSampleFormat(sample_fmt.swigValue(), planar));
    }

    public static Type getPackedSampleFormat(Type sample_fmt) {
        return Type.swigToEnum(VideoJNI.AudioFormat_getPackedSampleFormat(sample_fmt.swigValue()));
    }

    public static Type getPlanarSampleFormat(Type sample_fmt) {
        return Type.swigToEnum(VideoJNI.AudioFormat_getPlanarSampleFormat(sample_fmt.swigValue()));
    }

    public static int getBytesPerSample(Type sample_fmt) {
        return VideoJNI.AudioFormat_getBytesPerSample(sample_fmt.swigValue());
    }

    public static boolean isPlanar(Type sample_fmt) {
        return VideoJNI.AudioFormat_isPlanar(sample_fmt.swigValue());
    }

    public static int getBufferSizeNeeded(int numSamples, int numChannels, Type format) {
        return VideoJNI.AudioFormat_getBufferSizeNeeded(numSamples, numChannels, format.swigValue());
    }

    public static int getDataPlaneSizeNeeded(int numSamples, int numChannels, Type format) {
        return VideoJNI.AudioFormat_getDataPlaneSizeNeeded(numSamples, numChannels, format.swigValue());
    }

    public static enum Type {
        SAMPLE_FMT_NONE(VideoJNI.AudioFormat_SAMPLE_FMT_NONE_get()),
        SAMPLE_FMT_U8(VideoJNI.AudioFormat_SAMPLE_FMT_U8_get()),
        SAMPLE_FMT_S16(VideoJNI.AudioFormat_SAMPLE_FMT_S16_get()),
        SAMPLE_FMT_S32(VideoJNI.AudioFormat_SAMPLE_FMT_S32_get()),
        SAMPLE_FMT_FLT(VideoJNI.AudioFormat_SAMPLE_FMT_FLT_get()),
        SAMPLE_FMT_DBL(VideoJNI.AudioFormat_SAMPLE_FMT_DBL_get()),
        SAMPLE_FMT_U8P(VideoJNI.AudioFormat_SAMPLE_FMT_U8P_get()),
        SAMPLE_FMT_S16P(VideoJNI.AudioFormat_SAMPLE_FMT_S16P_get()),
        SAMPLE_FMT_S32P(VideoJNI.AudioFormat_SAMPLE_FMT_S32P_get()),
        SAMPLE_FMT_FLTP(VideoJNI.AudioFormat_SAMPLE_FMT_FLTP_get()),
        SAMPLE_FMT_DBLP(VideoJNI.AudioFormat_SAMPLE_FMT_DBLP_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Type swigToEnum(int swigValue) {
            Type[] swigValues = (Type[])Type.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Type swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Type.class + " with value " + swigValue);
        }

        private Type() {
            this.swigValue = SwigNext.next++;
        }

        private Type(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Type(Type swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

