/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.ferry.RefCounted;
import io.humble.video.VideoJNI;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicLong;

public class BitStreamFilterType
extends RefCounted {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected BitStreamFilterType(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.BitStreamFilterType_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected BitStreamFilterType(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.BitStreamFilterType_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(BitStreamFilterType obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public BitStreamFilterType copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new BitStreamFilterType(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof BitStreamFilterType) {
            equal = ((BitStreamFilterType)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + "@" + this.hashCode() + "[");
        result.append("name:" + this.getName() + ";");
        result.append("]");
        return result.toString();
    }

    public static Collection<BitStreamFilterType> getInstalledBitStreamFilterTypes() {
        HashSet<BitStreamFilterType> retval = new HashSet<BitStreamFilterType>();
        int count = BitStreamFilterType.getNumBitStreamFilterTypes();
        for (int i = 0; i < count; ++i) {
            BitStreamFilterType t = BitStreamFilterType.getBitStreamFilterType(i);
            if (t == null) continue;
            retval.add(t);
        }
        return retval;
    }

    public String getName() {
        return VideoJNI.BitStreamFilterType_getName(this.swigCPtr, this);
    }

    public static int getNumBitStreamFilterTypes() {
        return VideoJNI.BitStreamFilterType_getNumBitStreamFilterTypes();
    }

    public static BitStreamFilterType getBitStreamFilterType(int i) {
        long cPtr = VideoJNI.BitStreamFilterType_getBitStreamFilterType__SWIG_0(i);
        return cPtr == 0L ? null : new BitStreamFilterType(cPtr, false);
    }

    public static BitStreamFilterType getBitStreamFilterType(String name) {
        long cPtr = VideoJNI.BitStreamFilterType_getBitStreamFilterType__SWIG_1(name);
        return cPtr == 0L ? null : new BitStreamFilterType(cPtr, false);
    }
}

