/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.ferry.RefCounted;
import io.humble.video.KeyValueBag;
import io.humble.video.Property;
import io.humble.video.Rational;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class Configurable
extends RefCounted {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected Configurable(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.Configurable_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected Configurable(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.Configurable_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Configurable obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public Configurable copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new Configurable(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof Configurable) {
            equal = ((Configurable)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public int getNumProperties() {
        return VideoJNI.Configurable_getNumProperties(this.swigCPtr, this);
    }

    public Property getPropertyMetaData(int propertyNo) {
        long cPtr = VideoJNI.Configurable_getPropertyMetaData__SWIG_0(this.swigCPtr, this, propertyNo);
        return cPtr == 0L ? null : new Property(cPtr, false);
    }

    public Property getPropertyMetaData(String name) {
        long cPtr = VideoJNI.Configurable_getPropertyMetaData__SWIG_1(this.swigCPtr, this, name);
        return cPtr == 0L ? null : new Property(cPtr, false);
    }

    public void setProperty(String name, String value) {
        VideoJNI.Configurable_setProperty__SWIG_0(this.swigCPtr, this, name, value);
    }

    public void setProperty(String name, double value) {
        VideoJNI.Configurable_setProperty__SWIG_1(this.swigCPtr, this, name, value);
    }

    public void setProperty(String name, long value) {
        VideoJNI.Configurable_setProperty__SWIG_2(this.swigCPtr, this, name, value);
    }

    public void setProperty(String name, boolean value) {
        VideoJNI.Configurable_setProperty__SWIG_3(this.swigCPtr, this, name, value);
    }

    public void setProperty(String name, Rational value) {
        VideoJNI.Configurable_setProperty__SWIG_4(this.swigCPtr, this, name, Rational.getCPtr(value), value);
    }

    public String getPropertyAsString(String name) {
        return VideoJNI.Configurable_getPropertyAsString(this.swigCPtr, this, name);
    }

    public double getPropertyAsDouble(String name) {
        return VideoJNI.Configurable_getPropertyAsDouble(this.swigCPtr, this, name);
    }

    public long getPropertyAsLong(String name) {
        return VideoJNI.Configurable_getPropertyAsLong(this.swigCPtr, this, name);
    }

    public int getPropertyAsInt(String name) {
        return VideoJNI.Configurable_getPropertyAsInt(this.swigCPtr, this, name);
    }

    public Rational getPropertyAsRational(String name) {
        long cPtr = VideoJNI.Configurable_getPropertyAsRational(this.swigCPtr, this, name);
        return cPtr == 0L ? null : new Rational(cPtr, false);
    }

    public boolean getPropertyAsBoolean(String name) {
        return VideoJNI.Configurable_getPropertyAsBoolean(this.swigCPtr, this, name);
    }

    public void setProperty(KeyValueBag valuesToSet, KeyValueBag valuesNotFound) {
        VideoJNI.Configurable_setProperty__SWIG_5(this.swigCPtr, this, KeyValueBag.getCPtr(valuesToSet), valuesToSet, KeyValueBag.getCPtr(valuesNotFound), valuesNotFound);
    }
}

