/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.video.Configurable;
import io.humble.video.Property;
import io.humble.video.PropertyNotFoundException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);

    private Configuration() {
    }

    public static void printConfigurable(PrintStream stream, Configurable configObj) {
        stream.println("=======================================");
        stream.println("  " + configObj.getClass().getName() + " Properties");
        stream.println("=======================================");
        int numOptions = configObj.getNumProperties();
        for (int i = 0; i < numOptions; ++i) {
            Property prop = configObj.getPropertyMetaData(i);
            Configuration.printOption(stream, configObj, prop);
        }
    }

    public static void printOption(PrintStream stream, Configurable configObj, Property prop) {
        if (prop.getType() != Property.Type.PROPERTY_FLAGS) {
            stream.printf("  %s; default= %s; type=%s;\n", new Object[]{prop.getName(), configObj.getPropertyAsString(prop.getName()), prop.getType()});
        } else {
            stream.printf("  %s; default= %d; valid values=(", prop.getName(), configObj.getPropertyAsLong(prop.getName()));
            int numSettings = prop.getNumFlagSettings();
            long value = configObj.getPropertyAsLong(prop.getName());
            for (int i = 0; i < numSettings; ++i) {
                Property fprop = prop.getFlagConstant(i);
                long flagMask = fprop.getDefault();
                boolean isSet = (value & flagMask) > 0L;
                stream.printf("%s%s; ", isSet ? "+" : "-", fprop.getName());
            }
            stream.printf("); type=%s;\n", new Object[]{prop.getType()});
        }
        stream.printf("    help for %s: %s\n", prop.getName(), prop.getHelp() == null ? "no help available" : prop.getHelp());
    }

    public static void configure(Properties properties, Configurable config) {
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = properties.getProperty(name);
            if (value == null) continue;
            try {
                config.setProperty(name, value);
            }
            catch (PropertyNotFoundException e) {
                log.warn("Could not find property on object {}; name=\"{}\"; value=\"{}\"", new Object[]{config, name, value});
            }
        }
    }

    public static void configure(String file, Configurable config) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        props.load(new FileInputStream(file));
        Configuration.configure(props, config);
    }
}

