/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.ferry.RefCounted;
import io.humble.video.Codec;
import io.humble.video.VideoJNI;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;

public class ContainerFormat
extends RefCounted {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected ContainerFormat(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.ContainerFormat_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected ContainerFormat(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.ContainerFormat_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(ContainerFormat obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public ContainerFormat copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new ContainerFormat(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof ContainerFormat) {
            equal = ((ContainerFormat)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + "@" + this.hashCode() + "[");
        result.append("name:" + this.getName() + ";");
        result.append("longname:" + this.getName() + ";");
        result.append("extensions:" + this.getExtensions() + ";");
        result.append("flags:" + this.getFlags() + ";");
        result.append("]");
        return result.toString();
    }

    public Collection<Codec.ID> getSupportedCodecs() {
        LinkedList<Codec.ID> retval = new LinkedList<Codec.ID>();
        HashSet<Codec.ID> uniqueSet = new HashSet<Codec.ID>();
        int numCodecs = this.getNumSupportedCodecs();
        for (int i = 0; i < numCodecs; ++i) {
            Codec.ID id = this.getSupportedCodecId(i);
            if (id != Codec.ID.CODEC_ID_NONE && !uniqueSet.contains((Object)id)) {
                retval.add(id);
            }
            uniqueSet.add(id);
        }
        return retval;
    }

    public Collection<Long> getSupportedTags() {
        LinkedList<Long> retval = new LinkedList<Long>();
        HashSet<Long> uniqueSet = new HashSet<Long>();
        int numCodecs = this.getNumSupportedCodecs();
        for (int i = 0; i < numCodecs; ++i) {
            long tag = this.getSupportedCodecTag(i);
            Codec.ID id = this.getSupportedCodecId(i);
            if (id != Codec.ID.CODEC_ID_NONE && !uniqueSet.contains(tag)) {
                retval.add(tag);
            }
            uniqueSet.add(tag);
        }
        return retval;
    }

    public String getName() {
        return VideoJNI.ContainerFormat_getName(this.swigCPtr, this);
    }

    public String getLongName() {
        return VideoJNI.ContainerFormat_getLongName(this.swigCPtr, this);
    }

    public String getExtensions() {
        return VideoJNI.ContainerFormat_getExtensions(this.swigCPtr, this);
    }

    public int getFlags() {
        return VideoJNI.ContainerFormat_getFlags(this.swigCPtr, this);
    }

    public boolean getFlag(Flag flag) {
        return VideoJNI.ContainerFormat_getFlag(this.swigCPtr, this, flag.swigValue());
    }

    protected int getNumSupportedCodecs() {
        return VideoJNI.ContainerFormat_getNumSupportedCodecs(this.swigCPtr, this);
    }

    protected Codec.ID getSupportedCodecId(int n) {
        return Codec.ID.swigToEnum(VideoJNI.ContainerFormat_getSupportedCodecId(this.swigCPtr, this, n));
    }

    protected long getSupportedCodecTag(int n) {
        return VideoJNI.ContainerFormat_getSupportedCodecTag(this.swigCPtr, this, n);
    }

    public static enum Flag {
        INVALID_FLAG(VideoJNI.ContainerFormat_INVALID_FLAG_get()),
        NO_FILE(VideoJNI.ContainerFormat_NO_FILE_get()),
        NEED_NUMBER(VideoJNI.ContainerFormat_NEED_NUMBER_get()),
        SHOW_IDS(VideoJNI.ContainerFormat_SHOW_IDS_get()),
        RAW_PICTURE(VideoJNI.ContainerFormat_RAW_PICTURE_get()),
        GLOBAL_HEADER(VideoJNI.ContainerFormat_GLOBAL_HEADER_get()),
        NO_TIMESTAMPS(VideoJNI.ContainerFormat_NO_TIMESTAMPS_get()),
        GENERIC_INDEX(VideoJNI.ContainerFormat_GENERIC_INDEX_get()),
        TIMESTAMP_DISCONTINUITIES(VideoJNI.ContainerFormat_TIMESTAMP_DISCONTINUITIES_get()),
        VARIABLE_FPS(VideoJNI.ContainerFormat_VARIABLE_FPS_get()),
        NO_DIMENSIONS(VideoJNI.ContainerFormat_NO_DIMENSIONS_get()),
        NO_STREAMS(VideoJNI.ContainerFormat_NO_STREAMS_get()),
        NO_BINARY_SEARCH(VideoJNI.ContainerFormat_NO_BINARY_SEARCH_get()),
        NO_GENERIC_SEARCH(VideoJNI.ContainerFormat_NO_GENERIC_SEARCH_get()),
        NO_BYTE_SEEKING(VideoJNI.ContainerFormat_NO_BYTE_SEEKING_get()),
        ALLOW_FLUSH(VideoJNI.ContainerFormat_ALLOW_FLUSH_get()),
        NONSTRICT_TIMESTAMPS(VideoJNI.ContainerFormat_NONSTRICT_TIMESTAMPS_get()),
        SEEK_TO_PTS(VideoJNI.ContainerFormat_SEEK_TO_PTS_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Flag swigToEnum(int swigValue) {
            Flag[] swigValues = (Flag[])Flag.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Flag swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Flag.class + " with value " + swigValue);
        }

        private Flag() {
            this.swigValue = SwigNext.next++;
        }

        private Flag(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Flag(Flag swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

