/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.video.Codec;
import io.humble.video.Container;
import io.humble.video.DemuxerFormat;
import io.humble.video.DemuxerStream;
import io.humble.video.KeyValueBag;
import io.humble.video.MediaPacket;
import io.humble.video.VideoJNI;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class Demuxer
extends Container {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected Demuxer(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.Demuxer_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected Demuxer(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.Demuxer_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Demuxer obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public Demuxer copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new Demuxer(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof Demuxer) {
            equal = ((Demuxer)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    @Override
    public int hashCode() {
        return (int)this.swigCPtr;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder(super.toString());
        b.append("[").append("url=" + this.getURL() + ";").append("format:" + this.getFormat() + ";").append("]");
        return b.toString();
    }

    public static Demuxer make() {
        long cPtr = VideoJNI.Demuxer_make();
        return cPtr == 0L ? null : new Demuxer(cPtr, false);
    }

    public State getState() {
        return State.swigToEnum(VideoJNI.Demuxer_getState(this.swigCPtr, this));
    }

    public DemuxerFormat getFormat() {
        long cPtr = VideoJNI.Demuxer_getFormat(this.swigCPtr, this);
        return cPtr == 0L ? null : new DemuxerFormat(cPtr, false);
    }

    public void setInputBufferLength(int size) {
        VideoJNI.Demuxer_setInputBufferLength(this.swigCPtr, this, size);
    }

    public int getInputBufferLength() {
        return VideoJNI.Demuxer_getInputBufferLength(this.swigCPtr, this);
    }

    public void open(String url, DemuxerFormat format, boolean streamsCanBeAddedDynamically, boolean queryStreamMetaData, KeyValueBag options, KeyValueBag optionsNotSet) throws InterruptedException, IOException {
        VideoJNI.Demuxer_open(this.swigCPtr, this, url, DemuxerFormat.getCPtr(format), format, streamsCanBeAddedDynamically, queryStreamMetaData, KeyValueBag.getCPtr(options), options, KeyValueBag.getCPtr(optionsNotSet), optionsNotSet);
    }

    public void close() throws InterruptedException, IOException {
        VideoJNI.Demuxer_close(this.swigCPtr, this);
    }

    public DemuxerStream getStream(int streamIndex) throws InterruptedException, IOException {
        long cPtr = VideoJNI.Demuxer_getStream(this.swigCPtr, this, streamIndex);
        return cPtr == 0L ? null : new DemuxerStream(cPtr, false);
    }

    public int read(MediaPacket packet) throws InterruptedException, IOException {
        return VideoJNI.Demuxer_read(this.swigCPtr, this, MediaPacket.getCPtr(packet), packet);
    }

    public void queryStreamMetaData() throws InterruptedException, IOException {
        VideoJNI.Demuxer_queryStreamMetaData(this.swigCPtr, this);
    }

    public long getDuration() {
        return VideoJNI.Demuxer_getDuration(this.swigCPtr, this);
    }

    public long getStartTime() {
        return VideoJNI.Demuxer_getStartTime(this.swigCPtr, this);
    }

    public long getFileSize() {
        return VideoJNI.Demuxer_getFileSize(this.swigCPtr, this);
    }

    public int getBitRate() {
        return VideoJNI.Demuxer_getBitRate(this.swigCPtr, this);
    }

    public int getFlags() {
        return VideoJNI.Demuxer_getFlags(this.swigCPtr, this);
    }

    public void setFlags(int newFlags) {
        VideoJNI.Demuxer_setFlags(this.swigCPtr, this, newFlags);
    }

    public boolean getFlag(Container.Flag flag) {
        return VideoJNI.Demuxer_getFlag(this.swigCPtr, this, flag.swigValue());
    }

    public void setFlag(Container.Flag flag, boolean value) {
        VideoJNI.Demuxer_setFlag(this.swigCPtr, this, flag.swigValue(), value);
    }

    public String getURL() {
        return VideoJNI.Demuxer_getURL(this.swigCPtr, this);
    }

    public int getReadRetryCount() {
        return VideoJNI.Demuxer_getReadRetryCount(this.swigCPtr, this);
    }

    public void setReadRetryCount(int count) {
        VideoJNI.Demuxer_setReadRetryCount(this.swigCPtr, this, count);
    }

    public boolean canStreamsBeAddedDynamically() {
        return VideoJNI.Demuxer_canStreamsBeAddedDynamically(this.swigCPtr, this);
    }

    public KeyValueBag getMetaData() {
        long cPtr = VideoJNI.Demuxer_getMetaData(this.swigCPtr, this);
        return cPtr == 0L ? null : new KeyValueBag(cPtr, false);
    }

    public int setForcedAudioCodec(Codec.ID id) {
        return VideoJNI.Demuxer_setForcedAudioCodec(this.swigCPtr, this, id.swigValue());
    }

    public int setForcedVideoCodec(Codec.ID id) {
        return VideoJNI.Demuxer_setForcedVideoCodec(this.swigCPtr, this, id.swigValue());
    }

    public int setForcedSubtitleCodec(Codec.ID id) {
        return VideoJNI.Demuxer_setForcedSubtitleCodec(this.swigCPtr, this, id.swigValue());
    }

    public int seek(int stream_index, long min_ts, long ts, long max_ts, int flags) throws InterruptedException, IOException {
        return VideoJNI.Demuxer_seek(this.swigCPtr, this, stream_index, min_ts, ts, max_ts, flags);
    }

    public int getMaxDelay() {
        return VideoJNI.Demuxer_getMaxDelay(this.swigCPtr, this);
    }

    public void play() throws InterruptedException, IOException {
        VideoJNI.Demuxer_play(this.swigCPtr, this);
    }

    public void pause() throws InterruptedException, IOException {
        VideoJNI.Demuxer_pause(this.swigCPtr, this);
    }

    public static enum SeekFlag {
        SEEK_BACKWARD(VideoJNI.Demuxer_SEEK_BACKWARD_get()),
        SEEK_BYTE(VideoJNI.Demuxer_SEEK_BYTE_get()),
        SEEK_ANY(VideoJNI.Demuxer_SEEK_ANY_get()),
        SEEK_FRAME(VideoJNI.Demuxer_SEEK_FRAME_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static SeekFlag swigToEnum(int swigValue) {
            SeekFlag[] swigValues = (SeekFlag[])SeekFlag.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (SeekFlag swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + SeekFlag.class + " with value " + swigValue);
        }

        private SeekFlag() {
            this.swigValue = SwigNext.next++;
        }

        private SeekFlag(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private SeekFlag(SeekFlag swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum State {
        STATE_INITED,
        STATE_OPENED,
        STATE_PLAYING,
        STATE_PAUSED,
        STATE_CLOSED,
        STATE_ERROR;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static State swigToEnum(int swigValue) {
            State[] swigValues = (State[])State.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (State swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + State.class + " with value " + swigValue);
        }

        private State() {
            this.swigValue = SwigNext.next++;
        }

        private State(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private State(State swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

