/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.video.Codec;
import io.humble.video.ContainerFormat;
import io.humble.video.VideoJNI;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicLong;

public class DemuxerFormat
extends ContainerFormat {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected DemuxerFormat(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.DemuxerFormat_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected DemuxerFormat(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.DemuxerFormat_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(DemuxerFormat obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public DemuxerFormat copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new DemuxerFormat(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof DemuxerFormat) {
            equal = ((DemuxerFormat)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    @Override
    public int hashCode() {
        return (int)this.swigCPtr;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + "@" + this.hashCode() + "[");
        result.append("name:" + this.getName() + ";");
        result.append("description:" + this.getLongName() + ";");
        result.append("]");
        return result.toString();
    }

    public static Collection<DemuxerFormat> getFormats() {
        HashSet<DemuxerFormat> retval = new HashSet<DemuxerFormat>();
        int count = DemuxerFormat.getNumFormats();
        for (int i = 0; i < count; ++i) {
            DemuxerFormat fmt = DemuxerFormat.getFormat(i);
            if (fmt == null) continue;
            retval.add(fmt);
        }
        return retval;
    }

    @Override
    public String getName() {
        return VideoJNI.DemuxerFormat_getName(this.swigCPtr, this);
    }

    @Override
    public String getLongName() {
        return VideoJNI.DemuxerFormat_getLongName(this.swigCPtr, this);
    }

    @Override
    public String getExtensions() {
        return VideoJNI.DemuxerFormat_getExtensions(this.swigCPtr, this);
    }

    @Override
    public int getFlags() {
        return VideoJNI.DemuxerFormat_getFlags(this.swigCPtr, this);
    }

    @Override
    protected int getNumSupportedCodecs() {
        return VideoJNI.DemuxerFormat_getNumSupportedCodecs(this.swigCPtr, this);
    }

    @Override
    protected Codec.ID getSupportedCodecId(int n) {
        return Codec.ID.swigToEnum(VideoJNI.DemuxerFormat_getSupportedCodecId(this.swigCPtr, this, n));
    }

    @Override
    protected long getSupportedCodecTag(int n) {
        return VideoJNI.DemuxerFormat_getSupportedCodecTag(this.swigCPtr, this, n);
    }

    public static DemuxerFormat findFormat(String shortName) {
        long cPtr = VideoJNI.DemuxerFormat_findFormat(shortName);
        return cPtr == 0L ? null : new DemuxerFormat(cPtr, false);
    }

    protected static int getNumFormats() {
        return VideoJNI.DemuxerFormat_getNumFormats();
    }

    protected static DemuxerFormat getFormat(int index) {
        long cPtr = VideoJNI.DemuxerFormat_getFormat(index);
        return cPtr == 0L ? null : new DemuxerFormat(cPtr, false);
    }
}

