/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.video.Codec;
import io.humble.video.Coder;
import io.humble.video.KeyValueBag;
import io.humble.video.MediaAudio;
import io.humble.video.MediaPacket;
import io.humble.video.MediaPicture;
import io.humble.video.MediaSampled;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class Encoder
extends Coder {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected Encoder(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.Encoder_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected Encoder(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.Encoder_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Encoder obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public Encoder copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new Encoder(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof Encoder) {
            equal = ((Encoder)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    @Override
    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public long getNumDroppedFrames() {
        return VideoJNI.Encoder_getNumDroppedFrames(this.swigCPtr, this);
    }

    public static Encoder make(Codec codec) {
        long cPtr = VideoJNI.Encoder_make__SWIG_0(Codec.getCPtr(codec), codec);
        return cPtr == 0L ? null : new Encoder(cPtr, false);
    }

    public static Encoder make(Coder src) {
        long cPtr = VideoJNI.Encoder_make__SWIG_1(Coder.getCPtr(src), src);
        return cPtr == 0L ? null : new Encoder(cPtr, false);
    }

    @Override
    public void open(KeyValueBag inputOptions, KeyValueBag unsetOptions) {
        VideoJNI.Encoder_open(this.swigCPtr, this, KeyValueBag.getCPtr(inputOptions), inputOptions, KeyValueBag.getCPtr(unsetOptions), unsetOptions);
    }

    public void encodeVideo(MediaPacket output, MediaPicture picture) {
        VideoJNI.Encoder_encodeVideo(this.swigCPtr, this, MediaPacket.getCPtr(output), output, MediaPicture.getCPtr(picture), picture);
    }

    public void encodeAudio(MediaPacket output, MediaAudio samples) {
        VideoJNI.Encoder_encodeAudio(this.swigCPtr, this, MediaPacket.getCPtr(output), output, MediaAudio.getCPtr(samples), samples);
    }

    public void encode(MediaPacket output, MediaSampled media) {
        VideoJNI.Encoder_encode(this.swigCPtr, this, MediaPacket.getCPtr(output), output, MediaSampled.getCPtr(media), media);
    }
}

