/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.video.Configurable;
import io.humble.video.FilterGraph;
import io.humble.video.FilterLink;
import io.humble.video.MediaDescriptor;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class Filter
extends Configurable {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected Filter(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.Filter_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected Filter(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.Filter_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Filter obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public Filter copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new Filter(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof Filter) {
            equal = ((Filter)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    @Override
    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String getName() {
        return VideoJNI.Filter_getName(this.swigCPtr, this);
    }

    public int getNumInputs() {
        return VideoJNI.Filter_getNumInputs(this.swigCPtr, this);
    }

    public String getInputName(int index) {
        return VideoJNI.Filter_getInputName(this.swigCPtr, this, index);
    }

    public MediaDescriptor.Type getInputType(int index) {
        return MediaDescriptor.Type.swigToEnum(VideoJNI.Filter_getInputType(this.swigCPtr, this, index));
    }

    public FilterLink getInputLink(int index) {
        long cPtr = VideoJNI.Filter_getInputLink(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new FilterLink(cPtr, false);
    }

    public int getNumOutputs() {
        return VideoJNI.Filter_getNumOutputs(this.swigCPtr, this);
    }

    public String getOutputName(int index) {
        return VideoJNI.Filter_getOutputName(this.swigCPtr, this, index);
    }

    public MediaDescriptor.Type getOutputType(int index) {
        return MediaDescriptor.Type.swigToEnum(VideoJNI.Filter_getOutputType(this.swigCPtr, this, index));
    }

    public FilterLink getOutputLink(int index) {
        long cPtr = VideoJNI.Filter_getOutputLink(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new FilterLink(cPtr, false);
    }

    public FilterGraph getGraph() {
        long cPtr = VideoJNI.Filter_getGraph(this.swigCPtr, this);
        return cPtr == 0L ? null : new FilterGraph(cPtr, false);
    }

    public static enum CommandFlag {
        COMMAND_FLAG_ONE(VideoJNI.Filter_COMMAND_FLAG_ONE_get()),
        COMMAND_FLAG_FAST(VideoJNI.Filter_COMMAND_FLAG_FAST_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static CommandFlag swigToEnum(int swigValue) {
            CommandFlag[] swigValues = (CommandFlag[])CommandFlag.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (CommandFlag swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + CommandFlag.class + " with value " + swigValue);
        }

        private CommandFlag() {
            this.swigValue = SwigNext.next++;
        }

        private CommandFlag(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private CommandFlag(CommandFlag swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

