/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.video.AudioChannel;
import io.humble.video.AudioFormat;
import io.humble.video.Configurable;
import io.humble.video.Filter;
import io.humble.video.FilterAudioSink;
import io.humble.video.FilterAudioSource;
import io.humble.video.FilterPictureSink;
import io.humble.video.FilterPictureSource;
import io.humble.video.FilterSink;
import io.humble.video.FilterSource;
import io.humble.video.FilterType;
import io.humble.video.PixelFormat;
import io.humble.video.Rational;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class FilterGraph
extends Configurable {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected FilterGraph(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.FilterGraph_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected FilterGraph(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.FilterGraph_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(FilterGraph obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public FilterGraph copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new FilterGraph(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof FilterGraph) {
            equal = ((FilterGraph)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    @Override
    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public static FilterGraph make() {
        long cPtr = VideoJNI.FilterGraph_make();
        return cPtr == 0L ? null : new FilterGraph(cPtr, false);
    }

    public Filter addFilter(FilterType type, String name) {
        long cPtr = VideoJNI.FilterGraph_addFilter(this.swigCPtr, this, FilterType.getCPtr(type), type, name);
        return cPtr == 0L ? null : new Filter(cPtr, false);
    }

    public Filter getFilter(String name) {
        long cPtr = VideoJNI.FilterGraph_getFilter(this.swigCPtr, this, name);
        return cPtr == 0L ? null : new Filter(cPtr, false);
    }

    public FilterAudioSource addAudioSource(String name, int sampleRate, AudioChannel.Layout channelLayout, AudioFormat.Type format, Rational timeBase) {
        long cPtr = VideoJNI.FilterGraph_addAudioSource(this.swigCPtr, this, name, sampleRate, channelLayout.swigValue(), format.swigValue(), Rational.getCPtr(timeBase), timeBase);
        return cPtr == 0L ? null : new FilterAudioSource(cPtr, false);
    }

    public FilterPictureSource addPictureSource(String name, int width, int height, PixelFormat.Type format, Rational timeBase, Rational pixelAspectRatio) {
        long cPtr = VideoJNI.FilterGraph_addPictureSource(this.swigCPtr, this, name, width, height, format.swigValue(), Rational.getCPtr(timeBase), timeBase, Rational.getCPtr(pixelAspectRatio), pixelAspectRatio);
        return cPtr == 0L ? null : new FilterPictureSource(cPtr, false);
    }

    public FilterAudioSink addAudioSink(String name, int sampleRate, AudioChannel.Layout channelLayout, AudioFormat.Type format) {
        long cPtr = VideoJNI.FilterGraph_addAudioSink(this.swigCPtr, this, name, sampleRate, channelLayout.swigValue(), format.swigValue());
        return cPtr == 0L ? null : new FilterAudioSink(cPtr, false);
    }

    public FilterPictureSink addPictureSink(String name, PixelFormat.Type format) {
        long cPtr = VideoJNI.FilterGraph_addPictureSink(this.swigCPtr, this, name, format.swigValue());
        return cPtr == 0L ? null : new FilterPictureSink(cPtr, false);
    }

    public int getNumSources() {
        return VideoJNI.FilterGraph_getNumSources(this.swigCPtr, this);
    }

    public FilterSource getSource(int index) {
        long cPtr = VideoJNI.FilterGraph_getSource__SWIG_0(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new FilterSource(cPtr, false);
    }

    public FilterSource getSource(String name) {
        long cPtr = VideoJNI.FilterGraph_getSource__SWIG_1(this.swigCPtr, this, name);
        return cPtr == 0L ? null : new FilterSource(cPtr, false);
    }

    public int getNumSinks() {
        return VideoJNI.FilterGraph_getNumSinks(this.swigCPtr, this);
    }

    public FilterSink getSink(int index) {
        long cPtr = VideoJNI.FilterGraph_getSink__SWIG_0(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new FilterSink(cPtr, false);
    }

    public FilterSink getSink(String name) {
        long cPtr = VideoJNI.FilterGraph_getSink__SWIG_1(this.swigCPtr, this, name);
        return cPtr == 0L ? null : new FilterSink(cPtr, false);
    }

    public void setAutoConvert(AutoConvertFlag value) {
        VideoJNI.FilterGraph_setAutoConvert(this.swigCPtr, this, value.swigValue());
    }

    public AutoConvertFlag getAutoConvert() {
        return AutoConvertFlag.swigToEnum(VideoJNI.FilterGraph_getAutoConvert(this.swigCPtr, this));
    }

    public void open(String filterDescription) {
        VideoJNI.FilterGraph_open(this.swigCPtr, this, filterDescription);
    }

    public String sendCommand(String target, String command, String arguments, int flags) {
        return VideoJNI.FilterGraph_sendCommand(this.swigCPtr, this, target, command, arguments, flags);
    }

    public void queueCommand(String target, String command, String arguments, int flags, double ts) {
        VideoJNI.FilterGraph_queueCommand(this.swigCPtr, this, target, command, arguments, flags, ts);
    }

    public String getDisplayString() {
        return VideoJNI.FilterGraph_getDisplayString(this.swigCPtr, this);
    }

    public State getState() {
        return State.swigToEnum(VideoJNI.FilterGraph_getState(this.swigCPtr, this));
    }

    public static enum AutoConvertFlag {
        AUTO_CONVERT_ALL(VideoJNI.FilterGraph_AUTO_CONVERT_ALL_get()),
        AUTO_CONVERT_NONE(VideoJNI.FilterGraph_AUTO_CONVERT_NONE_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static AutoConvertFlag swigToEnum(int swigValue) {
            AutoConvertFlag[] swigValues = (AutoConvertFlag[])AutoConvertFlag.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (AutoConvertFlag swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + AutoConvertFlag.class + " with value " + swigValue);
        }

        private AutoConvertFlag() {
            this.swigValue = SwigNext.next++;
        }

        private AutoConvertFlag(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private AutoConvertFlag(AutoConvertFlag swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum State {
        STATE_INITED,
        STATE_OPENED,
        STATE_ERROR;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static State swigToEnum(int swigValue) {
            State[] swigValues = (State[])State.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (State swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + State.class + " with value " + swigValue);
        }

        private State() {
            this.swigValue = SwigNext.next++;
        }

        private State(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private State(State swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

