/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.ferry.RefCounted;
import io.humble.video.AudioChannel;
import io.humble.video.AudioFormat;
import io.humble.video.Filter;
import io.humble.video.FilterGraph;
import io.humble.video.MediaDescriptor;
import io.humble.video.PixelFormat;
import io.humble.video.Rational;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class FilterLink
extends RefCounted {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected FilterLink(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.FilterLink_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected FilterLink(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.FilterLink_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(FilterLink obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public FilterLink copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new FilterLink(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof FilterLink) {
            equal = ((FilterLink)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public FilterGraph getFilterGraph() {
        long cPtr = VideoJNI.FilterLink_getFilterGraph(this.swigCPtr, this);
        return cPtr == 0L ? null : new FilterGraph(cPtr, false);
    }

    public Filter getInputFilter() {
        long cPtr = VideoJNI.FilterLink_getInputFilter(this.swigCPtr, this);
        return cPtr == 0L ? null : new Filter(cPtr, false);
    }

    public String getInputPadName() {
        return VideoJNI.FilterLink_getInputPadName(this.swigCPtr, this);
    }

    public MediaDescriptor.Type getInputPadType() {
        return MediaDescriptor.Type.swigToEnum(VideoJNI.FilterLink_getInputPadType(this.swigCPtr, this));
    }

    public Filter getOutputFilter() {
        long cPtr = VideoJNI.FilterLink_getOutputFilter(this.swigCPtr, this);
        return cPtr == 0L ? null : new Filter(cPtr, false);
    }

    public String getOutputPadName() {
        return VideoJNI.FilterLink_getOutputPadName(this.swigCPtr, this);
    }

    public MediaDescriptor.Type getOutputPadType() {
        return MediaDescriptor.Type.swigToEnum(VideoJNI.FilterLink_getOutputPadType(this.swigCPtr, this));
    }

    public MediaDescriptor.Type getMediaType() {
        return MediaDescriptor.Type.swigToEnum(VideoJNI.FilterLink_getMediaType(this.swigCPtr, this));
    }

    public int getWidth() {
        return VideoJNI.FilterLink_getWidth(this.swigCPtr, this);
    }

    public int getHeight() {
        return VideoJNI.FilterLink_getHeight(this.swigCPtr, this);
    }

    public PixelFormat.Type getPixelFormat() {
        return PixelFormat.Type.swigToEnum(VideoJNI.FilterLink_getPixelFormat(this.swigCPtr, this));
    }

    public Rational getPixelAspectRatio() {
        long cPtr = VideoJNI.FilterLink_getPixelAspectRatio(this.swigCPtr, this);
        return cPtr == 0L ? null : new Rational(cPtr, false);
    }

    public AudioChannel.Layout getChannelLayout() {
        return AudioChannel.Layout.swigToEnum(VideoJNI.FilterLink_getChannelLayout(this.swigCPtr, this));
    }

    public int getSampleRate() {
        return VideoJNI.FilterLink_getSampleRate(this.swigCPtr, this);
    }

    public AudioFormat.Type getSampleFormat() {
        return AudioFormat.Type.swigToEnum(VideoJNI.FilterLink_getSampleFormat(this.swigCPtr, this));
    }

    public Rational getTimeBase() {
        long cPtr = VideoJNI.FilterLink_getTimeBase(this.swigCPtr, this);
        return cPtr == 0L ? null : new Rational(cPtr, false);
    }

    public void insertFilter(Filter filter, int srcPadIndex, int dstPadIndex) {
        VideoJNI.FilterLink_insertFilter(this.swigCPtr, this, Filter.getCPtr(filter), filter, srcPadIndex, dstPadIndex);
    }
}

