/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.video.FilterSource;
import io.humble.video.MediaPicture;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class FilterPictureSource
extends FilterSource {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected FilterPictureSource(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.FilterPictureSource_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected FilterPictureSource(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.FilterPictureSource_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(FilterPictureSource obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public FilterPictureSource copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new FilterPictureSource(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof FilterPictureSource) {
            equal = ((FilterPictureSource)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    @Override
    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public void addPicture(MediaPicture picture) {
        VideoJNI.FilterPictureSource_addPicture(this.swigCPtr, this, MediaPicture.getCPtr(picture), picture);
    }
}

