/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.ferry.RefCounted;
import io.humble.video.Global;
import io.humble.video.Rational;
import io.humble.video.VideoJNI;
import java.util.Calendar;
import java.util.Formatter;
import java.util.concurrent.atomic.AtomicLong;

public class Media
extends RefCounted {
    private volatile long swigCPtr;
    private static final long TIME_OFFSET = -Calendar.getInstance().getTimeZone().getRawOffset();
    public static final String DEFAULT_TIME_STAMP_FORMAT = "%1$tH:%1$tM:%1$tS.%1$tL";

    private void noop() {
        Buffer.make(null, 1);
    }

    protected Media(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.Media_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected Media(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.Media_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Media obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public Media copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new Media(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof Media) {
            equal = ((Media)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String getFormattedTimeStamp() {
        return this.getFormattedTimeStamp(DEFAULT_TIME_STAMP_FORMAT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormattedTimeStamp(String format) {
        String retval = null;
        Formatter formatter = new Formatter();
        try {
            Rational timeBase = this.getTimeBase();
            if (timeBase == null) {
                timeBase = Rational.make(1, (int)Global.DEFAULT_PTS_PER_SECOND);
            }
            retval = formatter.format(format, (long)((double)this.getTimeStamp() * timeBase.getDouble() * 1000.0) + TIME_OFFSET).toString();
            timeBase.delete();
        }
        finally {
            formatter.close();
        }
        return retval;
    }

    public long getTimeStamp() {
        return VideoJNI.Media_getTimeStamp(this.swigCPtr, this);
    }

    public void setTimeStamp(long aTimeStamp) {
        VideoJNI.Media_setTimeStamp(this.swigCPtr, this, aTimeStamp);
    }

    public Rational getTimeBase() {
        long cPtr = VideoJNI.Media_getTimeBase(this.swigCPtr, this);
        return cPtr == 0L ? null : new Rational(cPtr, false);
    }

    public boolean isKey() {
        return VideoJNI.Media_isKey(this.swigCPtr, this);
    }

    public boolean isComplete() {
        return VideoJNI.Media_isComplete(this.swigCPtr, this);
    }
}

