/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.video.AudioChannel;
import io.humble.video.AudioFormat;
import io.humble.video.MediaSampled;
import io.humble.video.Rational;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class MediaAudio
extends MediaSampled {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected MediaAudio(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.MediaAudio_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected MediaAudio(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.MediaAudio_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(MediaAudio obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public MediaAudio copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new MediaAudio(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof MediaAudio) {
            equal = ((MediaAudio)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    @Override
    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + "@" + this.hashCode() + "[");
        result.append("sample rate:" + this.getSampleRate() + ";");
        result.append("channels:" + this.getChannels() + ";");
        result.append("format:" + (Object)((Object)this.getFormat()) + ";");
        result.append("time stamp:" + this.getTimeStamp() + ";");
        result.append("complete:" + this.isComplete() + ";");
        result.append("num samples:" + this.getNumSamples() + ";");
        result.append("key:" + this.isKey() + ";");
        Rational timeBase = this.getTimeBase();
        result.append("time base:" + timeBase + ";");
        if (timeBase != null) {
            timeBase.delete();
        }
        result.append("planes:" + this.getNumDataPlanes() + ";");
        for (int i = 0; i < this.getNumDataPlanes(); ++i) {
            result.append("plane size[" + i + "]:" + this.getDataPlaneSize(i) + ";");
        }
        result.append("]");
        return result.toString();
    }

    public static MediaAudio make(int numSamples, int sampleRate, int channels, AudioChannel.Layout channelLayout, AudioFormat.Type format) {
        long cPtr = VideoJNI.MediaAudio_make__SWIG_0(numSamples, sampleRate, channels, channelLayout.swigValue(), format.swigValue());
        return cPtr == 0L ? null : new MediaAudio(cPtr, false);
    }

    public static MediaAudio make(Buffer buffer, int numSamples, int sampleRate, int channels, AudioChannel.Layout channelLayout, AudioFormat.Type format) {
        long cPtr = VideoJNI.MediaAudio_make__SWIG_1(Buffer.getCPtr(buffer), buffer, numSamples, sampleRate, channels, channelLayout.swigValue(), format.swigValue());
        return cPtr == 0L ? null : new MediaAudio(cPtr, false);
    }

    public static MediaAudio make(MediaAudio src, boolean copy) {
        long cPtr = VideoJNI.MediaAudio_make__SWIG_2(MediaAudio.getCPtr(src), src, copy);
        return cPtr == 0L ? null : new MediaAudio(cPtr, false);
    }

    public Buffer getData(int plane) {
        long cPtr = VideoJNI.MediaAudio_getData(this.swigCPtr, this, plane);
        return cPtr == 0L ? null : new Buffer(cPtr, false);
    }

    public int getDataPlaneSize(int plane) {
        return VideoJNI.MediaAudio_getDataPlaneSize(this.swigCPtr, this, plane);
    }

    public int getNumDataPlanes() {
        return VideoJNI.MediaAudio_getNumDataPlanes(this.swigCPtr, this);
    }

    public int getMaxNumSamples() {
        return VideoJNI.MediaAudio_getMaxNumSamples(this.swigCPtr, this);
    }

    @Override
    public int getNumSamples() {
        return VideoJNI.MediaAudio_getNumSamples(this.swigCPtr, this);
    }

    public void setNumSamples(int numSamples) {
        VideoJNI.MediaAudio_setNumSamples(this.swigCPtr, this, numSamples);
    }

    public int getBytesPerSample() {
        return VideoJNI.MediaAudio_getBytesPerSample(this.swigCPtr, this);
    }

    @Override
    public void setComplete(boolean complete) {
        VideoJNI.MediaAudio_setComplete(this.swigCPtr, this, complete);
    }

    public int getSampleRate() {
        return VideoJNI.MediaAudio_getSampleRate(this.swigCPtr, this);
    }

    public int getChannels() {
        return VideoJNI.MediaAudio_getChannels(this.swigCPtr, this);
    }

    public AudioFormat.Type getFormat() {
        return AudioFormat.Type.swigToEnum(VideoJNI.MediaAudio_getFormat(this.swigCPtr, this));
    }

    @Override
    public boolean isComplete() {
        return VideoJNI.MediaAudio_isComplete(this.swigCPtr, this);
    }

    @Override
    public boolean isKey() {
        return VideoJNI.MediaAudio_isKey(this.swigCPtr, this);
    }

    public boolean isPlanar() {
        return VideoJNI.MediaAudio_isPlanar(this.swigCPtr, this);
    }

    public AudioChannel.Layout getChannelLayout() {
        return AudioChannel.Layout.swigToEnum(VideoJNI.MediaAudio_getChannelLayout(this.swigCPtr, this));
    }
}

