/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.video.KeyValueBag;
import io.humble.video.Media;
import io.humble.video.Rational;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class MediaRaw
extends Media {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected MediaRaw(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.MediaRaw_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected MediaRaw(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.MediaRaw_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(MediaRaw obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public MediaRaw copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new MediaRaw(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof MediaRaw) {
            equal = ((MediaRaw)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    @Override
    public int hashCode() {
        return (int)this.swigCPtr;
    }

    @Override
    public long getTimeStamp() {
        return VideoJNI.MediaRaw_getTimeStamp(this.swigCPtr, this);
    }

    @Override
    public void setTimeStamp(long aTimeStamp) {
        VideoJNI.MediaRaw_setTimeStamp(this.swigCPtr, this, aTimeStamp);
    }

    @Override
    public Rational getTimeBase() {
        long cPtr = VideoJNI.MediaRaw_getTimeBase(this.swigCPtr, this);
        return cPtr == 0L ? null : new Rational(cPtr, false);
    }

    @Override
    public boolean isKey() {
        return VideoJNI.MediaRaw_isKey(this.swigCPtr, this);
    }

    public long getPts() {
        return VideoJNI.MediaRaw_getPts(this.swigCPtr, this);
    }

    public KeyValueBag getMetaData() {
        long cPtr = VideoJNI.MediaRaw_getMetaData(this.swigCPtr, this);
        return cPtr == 0L ? null : new KeyValueBag(cPtr, false);
    }

    public long getPacketPts() {
        return VideoJNI.MediaRaw_getPacketPts(this.swigCPtr, this);
    }

    public long getPacketDts() {
        return VideoJNI.MediaRaw_getPacketDts(this.swigCPtr, this);
    }

    public int getPacketSize() {
        return VideoJNI.MediaRaw_getPacketSize(this.swigCPtr, this);
    }

    public long getPacketDuration() {
        return VideoJNI.MediaRaw_getPacketDuration(this.swigCPtr, this);
    }

    public long getBestEffortTimeStamp() {
        return VideoJNI.MediaRaw_getBestEffortTimeStamp(this.swigCPtr, this);
    }

    public void setComplete(boolean value) {
        VideoJNI.MediaRaw_setComplete(this.swigCPtr, this, value);
    }

    public void setTimeBase(Rational timeBase) {
        VideoJNI.MediaRaw_setTimeBase(this.swigCPtr, this, Rational.getCPtr(timeBase), timeBase);
    }
}

