/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.video.MediaRaw;
import io.humble.video.MediaSubtitleRectangle;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class MediaSubtitle
extends MediaRaw {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected MediaSubtitle(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.MediaSubtitle_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected MediaSubtitle(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.MediaSubtitle_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(MediaSubtitle obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public MediaSubtitle copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new MediaSubtitle(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof MediaSubtitle) {
            equal = ((MediaSubtitle)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    @Override
    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public int getFormat() {
        return VideoJNI.MediaSubtitle_getFormat(this.swigCPtr, this);
    }

    public long getStartDisplayTime() {
        return VideoJNI.MediaSubtitle_getStartDisplayTime(this.swigCPtr, this);
    }

    public long getEndDisplayTime() {
        return VideoJNI.MediaSubtitle_getEndDisplayTime(this.swigCPtr, this);
    }

    public int getNumRectangles() {
        return VideoJNI.MediaSubtitle_getNumRectangles(this.swigCPtr, this);
    }

    @Override
    public long getTimeStamp() {
        return VideoJNI.MediaSubtitle_getTimeStamp(this.swigCPtr, this);
    }

    public MediaSubtitleRectangle getRectangle(int n) {
        long cPtr = VideoJNI.MediaSubtitle_getRectangle(this.swigCPtr, this, n);
        return cPtr == 0L ? null : new MediaSubtitleRectangle(cPtr, false);
    }

    @Override
    public void setTimeStamp(long timeStamp) {
        VideoJNI.MediaSubtitle_setTimeStamp(this.swigCPtr, this, timeStamp);
    }

    @Override
    public boolean isKey() {
        return VideoJNI.MediaSubtitle_isKey(this.swigCPtr, this);
    }

    @Override
    public long getPts() {
        return VideoJNI.MediaSubtitle_getPts(this.swigCPtr, this);
    }

    @Override
    public long getPacketPts() {
        return VideoJNI.MediaSubtitle_getPacketPts(this.swigCPtr, this);
    }

    @Override
    public long getPacketDts() {
        return VideoJNI.MediaSubtitle_getPacketDts(this.swigCPtr, this);
    }

    @Override
    public int getPacketSize() {
        return VideoJNI.MediaSubtitle_getPacketSize(this.swigCPtr, this);
    }

    @Override
    public long getPacketDuration() {
        return VideoJNI.MediaSubtitle_getPacketDuration(this.swigCPtr, this);
    }

    @Override
    public long getBestEffortTimeStamp() {
        return VideoJNI.MediaSubtitle_getBestEffortTimeStamp(this.swigCPtr, this);
    }

    @Override
    public boolean isComplete() {
        return VideoJNI.MediaSubtitle_isComplete(this.swigCPtr, this);
    }

    public void setComplete(boolean complete, long timestamp) {
        VideoJNI.MediaSubtitle_setComplete__SWIG_0(this.swigCPtr, this, complete, timestamp);
    }

    @Override
    public void setComplete(boolean complete) {
        VideoJNI.MediaSubtitle_setComplete__SWIG_1(this.swigCPtr, this, complete);
    }

    public static enum Type {
        SUBTITLE_NONE,
        SUBTITLE_BITMAP,
        SUBTITLE_TEXT,
        SUBTITLE_ASS;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Type swigToEnum(int swigValue) {
            Type[] swigValues = (Type[])Type.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Type swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Type.class + " with value " + swigValue);
        }

        private Type() {
            this.swigValue = SwigNext.next++;
        }

        private Type(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Type(Type swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

