/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.video.Codec;
import io.humble.video.ContainerFormat;
import io.humble.video.MediaDescriptor;
import io.humble.video.VideoJNI;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicLong;

public class MuxerFormat
extends ContainerFormat {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected MuxerFormat(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.MuxerFormat_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected MuxerFormat(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.MuxerFormat_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(MuxerFormat obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public MuxerFormat copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new MuxerFormat(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof MuxerFormat) {
            equal = ((MuxerFormat)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    @Override
    public int hashCode() {
        return (int)this.swigCPtr;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + "@" + this.hashCode() + "[");
        result.append("name:" + this.getName() + ";");
        result.append("description:" + this.getLongName() + ";");
        result.append("mimetype:" + this.getMimeType() + ";");
        result.append("extensions:" + this.getExtensions() + ";");
        result.append("]");
        return result.toString();
    }

    public static Collection<MuxerFormat> getFormats() {
        HashSet<MuxerFormat> retval = new HashSet<MuxerFormat>();
        int count = MuxerFormat.getNumFormats();
        for (int i = 0; i < count; ++i) {
            MuxerFormat fmt = MuxerFormat.getFormat(i);
            if (fmt == null) continue;
            retval.add(fmt);
        }
        return retval;
    }

    @Override
    public String getName() {
        return VideoJNI.MuxerFormat_getName(this.swigCPtr, this);
    }

    @Override
    public String getLongName() {
        return VideoJNI.MuxerFormat_getLongName(this.swigCPtr, this);
    }

    @Override
    public String getExtensions() {
        return VideoJNI.MuxerFormat_getExtensions(this.swigCPtr, this);
    }

    @Override
    public int getFlags() {
        return VideoJNI.MuxerFormat_getFlags(this.swigCPtr, this);
    }

    public Codec.ID getDefaultAudioCodecId() {
        return Codec.ID.swigToEnum(VideoJNI.MuxerFormat_getDefaultAudioCodecId(this.swigCPtr, this));
    }

    public Codec.ID getDefaultVideoCodecId() {
        return Codec.ID.swigToEnum(VideoJNI.MuxerFormat_getDefaultVideoCodecId(this.swigCPtr, this));
    }

    public Codec.ID getDefaultSubtitleCodecId() {
        return Codec.ID.swigToEnum(VideoJNI.MuxerFormat_getDefaultSubtitleCodecId(this.swigCPtr, this));
    }

    public String getMimeType() {
        return VideoJNI.MuxerFormat_getMimeType(this.swigCPtr, this);
    }

    public static MuxerFormat guessFormat(String shortName, String filename, String mimeType) {
        long cPtr = VideoJNI.MuxerFormat_guessFormat(shortName, filename, mimeType);
        return cPtr == 0L ? null : new MuxerFormat(cPtr, false);
    }

    public Codec.ID guessCodec(String shortName, String filename, String mimeType, MediaDescriptor.Type type) {
        return Codec.ID.swigToEnum(VideoJNI.MuxerFormat_guessCodec(this.swigCPtr, this, shortName, filename, mimeType, type.swigValue()));
    }

    @Override
    protected int getNumSupportedCodecs() {
        return VideoJNI.MuxerFormat_getNumSupportedCodecs(this.swigCPtr, this);
    }

    public long getBestCodecTag(Codec.ID id) {
        return VideoJNI.MuxerFormat_getBestCodecTag(this.swigCPtr, this, id.swigValue());
    }

    @Override
    protected Codec.ID getSupportedCodecId(int n) {
        return Codec.ID.swigToEnum(VideoJNI.MuxerFormat_getSupportedCodecId(this.swigCPtr, this, n));
    }

    @Override
    protected long getSupportedCodecTag(int n) {
        return VideoJNI.MuxerFormat_getSupportedCodecTag(this.swigCPtr, this, n);
    }

    public static int getNumFormats() {
        return VideoJNI.MuxerFormat_getNumFormats();
    }

    public static MuxerFormat getFormat(int index) {
        long cPtr = VideoJNI.MuxerFormat_getFormat(index);
        return cPtr == 0L ? null : new MuxerFormat(cPtr, false);
    }
}

