/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.video.Coder;
import io.humble.video.ContainerStream;
import io.humble.video.Muxer;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class MuxerStream
extends ContainerStream {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected MuxerStream(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.MuxerStream_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected MuxerStream(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.MuxerStream_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(MuxerStream obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public MuxerStream copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new MuxerStream(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof MuxerStream) {
            equal = ((MuxerStream)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    @Override
    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + "@" + this.hashCode() + "[");
        result.append("index:" + this.getIndex() + ";");
        result.append("id:" + this.getId() + ";");
        result.append("framerate:" + this.getFrameRate() + ";");
        result.append("timebase:" + this.getTimeBase() + ";");
        result.append("]");
        return result.toString();
    }

    public Coder getCoder() {
        long cPtr = VideoJNI.MuxerStream_getCoder(this.swigCPtr, this);
        return cPtr == 0L ? null : new Coder(cPtr, false);
    }

    public Muxer getMuxer() {
        long cPtr = VideoJNI.MuxerStream_getMuxer(this.swigCPtr, this);
        return cPtr == 0L ? null : new Muxer(cPtr, false);
    }
}

