/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video.awt;

import io.humble.video.MediaPicture;
import io.humble.video.MediaPictureResampler;
import io.humble.video.PixelFormat;
import io.humble.video.awt.MediaPictureConverter;
import java.awt.image.BufferedImage;

abstract class AMediaPictureConverter
implements MediaPictureConverter {
    protected MediaPictureResampler mToPictureResampler = null;
    protected MediaPictureResampler mToImageResampler = null;
    protected int mPictureWidth;
    protected int mPictureHeight;
    protected int mImageWidth;
    protected int mImageHeight;
    private final PixelFormat.Type mPictureType;
    private final PixelFormat.Type mRequiredPictureType;
    private final int mImageType;
    private final String mDescription;

    public AMediaPictureConverter(PixelFormat.Type pictureType, PixelFormat.Type requiredPictureType, int imageType, int pictureWidth, int pictureHeight, int imageWidth, int imageHeight) {
        String resampleDescription = "";
        this.mPictureType = pictureType;
        this.mRequiredPictureType = requiredPictureType;
        this.mImageType = imageType;
        this.mPictureWidth = pictureWidth;
        this.mPictureHeight = pictureHeight;
        this.mImageWidth = imageWidth;
        this.mImageHeight = imageHeight;
        if (!this.mPictureType.equals((Object)this.mRequiredPictureType) || this.mPictureWidth != this.mImageWidth || this.mPictureHeight != this.mImageHeight) {
            this.mToImageResampler = MediaPictureResampler.make(this.mImageWidth, this.mImageHeight, this.mRequiredPictureType, this.mPictureWidth, this.mPictureHeight, this.mPictureType, 0);
            this.mToImageResampler.open();
            this.mToPictureResampler = MediaPictureResampler.make(this.mPictureWidth, this.mPictureHeight, this.mPictureType, this.mImageWidth, this.mImageHeight, this.mRequiredPictureType, 0);
            this.mToPictureResampler.open();
            resampleDescription = "Pictures will be resampled to and from " + (Object)((Object)this.mRequiredPictureType) + " during translation.";
        }
        this.mDescription = "A converter which translates [" + pictureWidth + "x" + pictureHeight + "] MediaPicture type " + (Object)((Object)pictureType) + " to and from [" + imageWidth + "x" + imageHeight + "] BufferedImage type " + imageType + ".  " + resampleDescription;
    }

    @Override
    public PixelFormat.Type getPictureType() {
        return this.mPictureType;
    }

    protected PixelFormat.Type getRequiredPictureType() {
        return this.mRequiredPictureType;
    }

    @Override
    public int getImageType() {
        return this.mImageType;
    }

    @Override
    public boolean willResample() {
        return null != this.mToPictureResampler && null != this.mToImageResampler;
    }

    protected static MediaPicture resample(MediaPicture input, MediaPictureResampler resampler) {
        MediaPicture output = MediaPicture.make(resampler.getOutputWidth(), resampler.getOutputHeight(), resampler.getOutputFormat());
        return AMediaPictureConverter.resample(output, input, resampler);
    }

    protected static MediaPicture resample(MediaPicture output, MediaPicture input, MediaPictureResampler resampler) {
        resampler.resample(output, input);
        return output;
    }

    protected void validateImage(BufferedImage image) {
        if (image == null) {
            throw new IllegalArgumentException("The passed image is NULL.");
        }
        if (image.getType() != this.getImageType()) {
            throw new IllegalArgumentException("The passed image is of type #" + image.getType() + " but is required to be of BufferedImage type #" + this.getImageType() + ".");
        }
    }

    protected void validatePicture(MediaPicture picture) {
        if (picture == null) {
            throw new IllegalArgumentException("The picture is NULL.");
        }
        if (!picture.isComplete()) {
            throw new IllegalArgumentException("The picture is not complete.");
        }
        PixelFormat.Type type = picture.getFormat();
        if (type != this.getPictureType() && this.willResample() && type != this.mToImageResampler.getOutputFormat()) {
            throw new IllegalArgumentException("Picture is of type: " + (Object)((Object)type) + ", but must be " + (Object)((Object)this.getPictureType()) + (this.willResample() ? " or " + (Object)((Object)this.mToImageResampler.getOutputFormat()) : "") + ".");
        }
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    public String toString() {
        return this.getDescription();
    }

    @Override
    public void delete() {
        if (this.mToPictureResampler != null) {
            this.mToPictureResampler.delete();
        }
        this.mToPictureResampler = null;
        if (this.mToImageResampler != null) {
            this.mToImageResampler.delete();
        }
        this.mToImageResampler = null;
    }
}

