/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video.awt;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ImageFrame
extends JFrame {
    private static final long serialVersionUID = -4752966848100689153L;
    private final ImageComponent mOnscreenPicture = new ImageComponent();
    private static boolean mIsHeadless = GraphicsEnvironment.isHeadless();

    public static ImageFrame make() {
        return mIsHeadless ? null : new ImageFrame();
    }

    private ImageFrame() {
        final ImageFrame thisClosure = this;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ImageFrame.this.setDefaultCloseOperation(3);
                    ImageFrame.this.getContentPane().add(ImageFrame.this.mOnscreenPicture);
                    thisClosure.setVisible(true);
                    thisClosure.pack();
                }
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException("The UI thread got interrupted; fail");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("The UI thread could not execute our closure; fail");
        }
    }

    public void setImage(Image aImage) {
        this.mOnscreenPicture.setImage(aImage);
    }

    public class ImageComponent
    extends JComponent {
        private static final long serialVersionUID = 5584422798735147930L;
        private Image mImage;
        private Dimension mSize = new Dimension(0, 0);

        public void setImage(Image image) {
            SwingUtilities.invokeLater(new ImageRunnable(image));
        }

        public void setImageSize(Dimension newSize) {
        }

        public ImageComponent() {
            this.setSize(this.mSize);
        }

        @Override
        public synchronized void paint(Graphics g) {
            if (this.mImage != null) {
                g.drawImage(this.mImage, 0, 0, this);
            }
        }

        private class ImageRunnable
        implements Runnable {
            private final Image newImage;

            public ImageRunnable(Image newImage) {
                this.newImage = newImage;
            }

            @Override
            public void run() {
                ImageComponent.this.mImage = this.newImage;
                Dimension newSize = new Dimension(ImageComponent.this.mImage.getWidth(null), ImageComponent.this.mImage.getHeight(null));
                if (!newSize.equals(ImageComponent.this.mSize)) {
                    ImageComponent.this.mSize = newSize;
                    ImageFrame.this.setSize(ImageComponent.this.mImage.getWidth(null), ImageComponent.this.mImage.getHeight(null));
                    ImageFrame.this.setVisible(true);
                }
                ImageComponent.this.repaint();
            }
        }
    }
}

